/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ConcurrencyTest
extends TestCase {
    static final boolean FULL_TEST = false;
    static final int MODEL_SIZE = 10;
    static final int NUM_THREADS = 20;
    static final int TEST_LENGTH = 20;
    static final int NUM_RUNS = 3;

    public ConcurrencyTest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(ConcurrencyTest.class);
    }

    private void runConcurrencyTest(ModelCreator modelCreator, String runId) throws InterruptedException {
        try {
            for (int i = 0; i < 3; ++i) {
                this.doTestConcurrency(modelCreator.createModel());
            }
        }
        catch (JenaException e) {
            ConcurrencyTest.assertTrue((String)e.getMessage(), (boolean)false);
        }
    }

    private void doTestConcurrency(final OntModel model) throws InterruptedException {
        int i;
        String NS = "urn:x-hp:eg/";
        model.enterCriticalSection(false);
        final OntClass Top = model.createClass("urn:x-hp:eg/Top");
        for (int i2 = 0; i2 < 10; ++i2) {
            OntClass C = model.createClass("urn:x-hp:eg/C" + i2);
            Top.addSubClass((Resource)C);
            model.createIndividual("urn:x-hp:eg/i" + i2, (Resource)C);
        }
        model.leaveCriticalSection();
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        for (i = 0; i < 20; ++i) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class QueryExecutingRunnable
            implements Runnable {
                QueryExecutingRunnable() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long runStartedAt = System.currentTimeMillis();
                    while (System.currentTimeMillis() - runStartedAt < 20L) {
                        Thread.yield();
                        model.enterCriticalSection(true);
                        try {
                            StmtIterator it = model.listStatements();
                            while (it.hasNext()) {
                                it.nextStatement();
                            }
                            it.close();
                            int count = 0;
                            ExtendedIterator ei = Top.listInstances();
                            while (ei.hasNext()) {
                                ei.next();
                                ++count;
                            }
                            ei.close();
                            if (10 == count) continue;
                            throw new JenaException("Failure - found " + count + " instance, expected " + 10);
                        }
                        finally {
                            model.leaveCriticalSection();
                        }
                    }
                }
            }
            executorService.submit(new QueryExecutingRunnable());
        }
        executorService.shutdown();
        Thread.sleep(70L);
        for (i = 0; i < 50 && !executorService.isTerminated(); ++i) {
            Thread.sleep(100L);
        }
        if (!executorService.isTerminated()) {
            ConcurrencyTest.assertTrue((String)"Failed to terminate execution", (boolean)false);
        }
    }

    public void testWithOWLMemMicroRuleInfModel() throws InterruptedException {
        this.runConcurrencyTest(new ModelCreator(){

            public OntModel createModel() {
                return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
            }
        }, "OWL_MEM_MICRO_RULE_INF");
    }

    private static interface ModelCreator {
        public OntModel createModel();
    }
}

