/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.N3JenaWriterPP;
import com.hp.hpl.jena.n3.N3JenaWriterPlain;
import com.hp.hpl.jena.n3.N3JenaWriterTriples;
import com.hp.hpl.jena.n3.N3TurtleJenaWriter;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import com.hp.hpl.jena.test.JenaTestBase;
import com.hp.hpl.jena.xmloutput.impl.Abbreviated;
import com.hp.hpl.jena.xmloutput.impl.Basic;
import java.util.HashMap;
import java.util.Map;

public class TestRDFWriterMap
extends JenaTestBase {
    public static final String TURTLE_WRITER_ALT2 = "TTL";
    public static final String TURTLE_WRITER_ALT1 = "Turtle";
    public static final String TURTLE_WRITER = "TURTLE";
    public static final String RDF_XML = "RDF/XML";
    public static final String RDF_XML_ABBREV = "RDF/XML-ABBREV";
    public static final String NTRIPLE = "N-TRIPLE";
    public static final String NTRIPLES = "N-TRIPLES";
    public static final String N3 = "N3";
    public static final String N3_PLAIN = "N3-PLAIN";
    public static final String N3_PP = "N3-PP";
    public static final String N3_TRIPLE = "N3-TRIPLE";
    public static final String N3_TRIPLES = "N3-TRIPLES";

    public TestRDFWriterMap(String name) {
        super(name);
    }

    public void testMe() {
        TestRDFWriterMap.fail((String)"SPOO");
    }

    public void testWritersAbsent() {
        this.testWriterAbsent(TURTLE_WRITER);
        this.testWriterAbsent(TURTLE_WRITER_ALT1);
        this.testWriterAbsent(TURTLE_WRITER_ALT2);
        this.testWriterAbsent(RDF_XML);
        this.testWriterAbsent(RDF_XML_ABBREV);
        this.testWriterAbsent(NTRIPLE);
        this.testWriterAbsent(NTRIPLES);
        this.testWriterAbsent(N3);
        this.testWriterAbsent(N3_PP);
        this.testWriterAbsent(N3_PLAIN);
        this.testWriterAbsent(N3_TRIPLE);
        this.testWriterAbsent(N3_TRIPLES);
    }

    private void testWriterAbsent(String w) {
        RDFWriterMap x = new RDFWriterMap(false);
        try {
            x.getWriter(w);
        }
        catch (NoWriterForLangException e) {
            TestRDFWriterMap.assertEquals((String)w, (String)e.getMessage());
        }
    }

    public void testWritersPresent() {
        RDFWriterMap x = new RDFWriterMap(true);
        TestRDFWriterMap.assertEquals(N3TurtleJenaWriter.class, x.getWriter(TURTLE_WRITER).getClass());
        TestRDFWriterMap.assertEquals(N3TurtleJenaWriter.class, x.getWriter(TURTLE_WRITER_ALT1).getClass());
        TestRDFWriterMap.assertEquals(N3TurtleJenaWriter.class, x.getWriter(TURTLE_WRITER_ALT2).getClass());
        TestRDFWriterMap.assertEquals(Basic.class, x.getWriter(RDF_XML).getClass());
        TestRDFWriterMap.assertEquals(Abbreviated.class, x.getWriter(RDF_XML_ABBREV).getClass());
        TestRDFWriterMap.assertEquals(NTripleWriter.class, x.getWriter(NTRIPLE).getClass());
        TestRDFWriterMap.assertEquals(NTripleWriter.class, x.getWriter(NTRIPLES).getClass());
        TestRDFWriterMap.assertEquals(N3JenaWriter.class, x.getWriter(N3).getClass());
        TestRDFWriterMap.assertEquals(N3JenaWriterPP.class, x.getWriter(N3_PP).getClass());
        TestRDFWriterMap.assertEquals(N3JenaWriterPlain.class, x.getWriter(N3_PLAIN).getClass());
        TestRDFWriterMap.assertEquals(N3JenaWriterTriples.class, x.getWriter(N3_TRIPLE).getClass());
        TestRDFWriterMap.assertEquals(N3JenaWriterTriples.class, x.getWriter(N3_TRIPLES).getClass());
    }

    public void testDefaultWriter() {
        RDFWriterMap x = new RDFWriterMap(true);
        TestRDFWriterMap.assertEquals(x.getWriter(RDF_XML).getClass(), x.getWriter().getClass());
    }

    public static class RDFWriterMap
    implements RDFWriterF {
        protected final Map<String, Class<RDFWriter>> map = new HashMap<String, Class<RDFWriter>>();

        public RDFWriterMap(boolean preloadDefaults) {
            if (preloadDefaults) {
                this.loadDefaults();
            }
        }

        private void loadDefaults() {
            this.setWriterClassName(TestRDFWriterMap.TURTLE_WRITER, "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
            this.setWriterClassName(TestRDFWriterMap.TURTLE_WRITER_ALT1, "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
            this.setWriterClassName(TestRDFWriterMap.TURTLE_WRITER_ALT2, "com.hp.hpl.jena.n3.N3TurtleJenaWriter");
            this.setWriterClassName(TestRDFWriterMap.RDF_XML, "com.hp.hpl.jena.xmloutput.impl.Basic");
            this.setWriterClassName(TestRDFWriterMap.RDF_XML_ABBREV, "com.hp.hpl.jena.xmloutput.impl.Abbreviated");
            this.setWriterClassName(TestRDFWriterMap.N3, "com.hp.hpl.jena.n3.N3JenaWriter");
            this.setWriterClassName(TestRDFWriterMap.N3_PLAIN, "com.hp.hpl.jena.n3.N3JenaWriterPlain");
            this.setWriterClassName(TestRDFWriterMap.N3_PP, "com.hp.hpl.jena.n3.N3JenaWriterPP");
            this.setWriterClassName(TestRDFWriterMap.N3_TRIPLE, "com.hp.hpl.jena.n3.N3JenaWriterTriples");
            this.setWriterClassName(TestRDFWriterMap.N3_TRIPLES, "com.hp.hpl.jena.n3.N3JenaWriterTriples");
            this.setWriterClassName(TestRDFWriterMap.NTRIPLE, "com.hp.hpl.jena.rdf.model.impl.NTripleWriter");
            this.setWriterClassName(TestRDFWriterMap.NTRIPLES, "com.hp.hpl.jena.rdf.model.impl.NTripleWriter");
        }

        public RDFWriter getWriter() {
            return this.getWriter(TestRDFWriterMap.RDF_XML);
        }

        public RDFWriter getWriter(String lang) {
            Class<RDFWriter> result = this.map.get(lang);
            if (result == null) {
                throw new NoWriterForLangException(lang);
            }
            try {
                return result.newInstance();
            }
            catch (Exception e) {
                throw new JenaException((Throwable)e);
            }
        }

        public String setWriterClassName(String lang, String className) {
            try {
                Class<RDFWriter> old = this.map.get(lang);
                Class<?> c = Class.forName(className);
                if (RDFWriter.class.isAssignableFrom(c)) {
                    Class<?> x = c;
                    this.map.put(lang, x);
                }
                return old == null ? null : old.getName();
            }
            catch (ClassNotFoundException e) {
                throw new JenaException((Throwable)e);
            }
        }
    }
}

