/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.AbstractTestPrefixMapping;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.CollectionFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNamespace
extends ModelTestBase {
    public TestNamespace(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestNamespace.class);
    }

    public void testReadPrefixes() {
        Model m = ModelFactory.createDefaultModel();
        m.read("file:testing/wg/rdf-ns-prefix-confusion/test0014.rdf");
        Map ns = m.getNsPrefixMap();
        TestNamespace.assertEquals((String)"namespace eg", (String)"http://example.org/", (String)((String)ns.get("eg")));
        TestNamespace.assertEquals((String)"namespace rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)((String)ns.get("rdf")));
        TestNamespace.assertEquals((String)"not present", null, (String)((String)ns.get("spoo")));
    }

    public void testWritePrefixes() throws IOException {
        Model m = ModelFactory.createDefaultModel();
        ModelCom.addNamespaces((Model)m, this.makePrefixes("fred=ftp://net.fred.org/;spoo=http://spoo.net/"));
        File f = File.createTempFile("hedgehog", ".rdf");
        m.add(TestNamespace.statement(m, "http://spoo.net/S http://spoo.net/P http://spoo.net/O"));
        m.add(TestNamespace.statement(m, "http://spoo.net/S ftp://net.fred.org/P http://spoo.net/O"));
        m.write((OutputStream)new FileOutputStream(f));
        Model m2 = ModelFactory.createDefaultModel();
        m2.read("file:" + f.getAbsolutePath());
        Map ns = m2.getNsPrefixMap();
        TestNamespace.assertEquals((String)"namespace spoo", (String)"http://spoo.net/", (String)((String)ns.get("spoo")));
        TestNamespace.assertEquals((String)"namespace fred", (String)"ftp://net.fred.org/", (String)((String)ns.get("fred")));
        f.deleteOnExit();
    }

    private Map<String, Set<String>> makePrefixes(String prefixes) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        StringTokenizer st = new StringTokenizer(prefixes, ";");
        while (st.hasMoreTokens()) {
            String def = st.nextToken();
            int eq = def.indexOf(61);
            result.put(def.substring(0, eq), this.set(def.substring(eq + 1)));
        }
        return result;
    }

    private Set<String> set(String element) {
        Set s = CollectionFactory.createHashedSet();
        s.add(element);
        return s;
    }

    public void testUseEasyPrefix() {
        AbstractTestPrefixMapping.testUseEasyPrefix("default model", (PrefixMapping)ModelFactory.createDefaultModel());
    }
}

