/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.impl.AdhocDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.LiteralRequiredException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestLiteralImpl
extends ModelTestBase {
    public TestLiteralImpl(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestLiteralImpl.class);
    }

    public void testCannotAsNonLiteral() {
        Model m = ModelFactory.createDefaultModel();
        try {
            TestLiteralImpl.resource(m, "plumPie").as(Literal.class);
            TestLiteralImpl.fail((String)"non-literal cannot be converted to literal");
        }
        catch (LiteralRequiredException l) {
            TestLiteralImpl.pass();
        }
    }

    public void testAsLiteral() {
        Model m = ModelFactory.createDefaultModel();
        TestLiteralImpl.literal(m, "17").as(Literal.class);
    }

    public void testLiteralHasModel() {
        Model m = ModelFactory.createDefaultModel();
        this.testLiteralHasModel(m, m.createLiteral("hello, world"));
        this.testLiteralHasModel(m, m.createLiteral("hello, world", "en-UK"));
        this.testLiteralHasModel(m, m.createLiteral("hello, world", true));
        this.testLiteralHasModel(m, m.createTypedLiteral("hello, world"));
        this.testLiteralHasModel(m, m.createTypedLiteral(false));
        this.testLiteralHasModel(m, m.createTypedLiteral(17));
        this.testLiteralHasModel(m, m.createTypedLiteral('x'));
    }

    private void testLiteralHasModel(Model m, Literal lit) {
        TestLiteralImpl.assertSame((Object)m, (Object)lit.getModel());
    }

    public void testInModel() {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        Literal l1 = m1.createLiteral("17");
        Literal l2 = l1.inModel(m2);
        TestLiteralImpl.assertEquals((Object)l1, (Object)l2);
        TestLiteralImpl.assertSame((Object)m2, (Object)l2.getModel());
    }

    public void testSameAdhocClassUS() {
        Model m = ModelFactory.createDefaultModel();
        Resource ra = m.createResource("eh:/rhubarb");
        Resource rb = m.createResource("eh:/cottage");
        TestLiteralImpl.assertNull((String)"not expecting ResourceImpl to have RDF Datatype get", (Object)TypeMapper.getInstance().getTypeByValue((Object)ra));
        Literal la = m.createTypedLiteral((Object)ra);
        Literal lb = m.createTypedLiteral((Object)rb);
        TestLiteralImpl.assertInstanceOf(AdhocDatatype.class, la.getDatatype());
        TestLiteralImpl.assertSame((Object)la.getDatatype(), (Object)lb.getDatatype());
    }

    public void testTypedLiteralTypesAndValues() {
        Model m = ModelFactory.createDefaultModel();
        Resource r = m.createResource("eh:/rhubarb");
        Literal typed = m.createTypedLiteral((Object)r);
        Literal string = m.createLiteral(r.getURI());
        TestLiteralImpl.assertEquals((String)string.getLexicalForm(), (String)typed.getLexicalForm());
        TestLiteralImpl.assertEquals((String)string.getLanguage(), (String)typed.getLanguage());
        TestLiteralImpl.assertDiffer(string.getDatatypeURI(), typed.getDatatypeURI());
        TestLiteralImpl.assertNotNull((String)"a datatype should have been invented for Resource[Impl]", (Object)typed.getDatatype());
        TestLiteralImpl.assertDiffer(typed, string);
        TestLiteralImpl.assertDiffer(typed.getValue(), string.getValue());
        TestLiteralImpl.assertEquals((Object)r, (Object)typed.getValue());
        TestLiteralImpl.assertDiffer(typed.hashCode(), string.hashCode());
    }
}

