/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestModel
extends ModelTestBase {
    private Model model;
    protected String[][] cases = new String[][]{{"x R y", "x R y", ""}, {"x R y; a P b", "x R y", "a P b"}, {"x R y; a P b", "?? R y", "a P b"}, {"x R y; a P b", "x R ??", "a P b"}, {"x R y; a P b", "x ?? y", "a P b"}, {"x R y; a P b", "?? ?? ??", ""}, {"x R y; a P b; c P d", "?? P ??", "x R y"}, {"x R y; a P b; x S y", "x ?? ??", "a P b"}};

    public AbstractTestModel(String name) {
        super(name);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
    }

    public void tearDown() {
        this.model.close();
    }

    public void testTransactions() {
        Command cmd = new Command(){

            public Object execute() {
                return null;
            }
        };
        if (this.model.supportsTransactions()) {
            this.model.executeInTransaction(cmd);
        }
    }

    public void testCreateResourceFromNode() {
        RDFNode S = this.model.getRDFNode(NodeCreateUtils.create("spoo:S"));
        AbstractTestModel.assertInstanceOf(Resource.class, S);
        AbstractTestModel.assertEquals((String)"spoo:S", (String)((Resource)S).getURI());
    }

    public void testCreateLiteralFromNode() {
        RDFNode S = this.model.getRDFNode(NodeCreateUtils.create("42"));
        AbstractTestModel.assertInstanceOf(Literal.class, S);
        AbstractTestModel.assertEquals((String)"42", (String)((Literal)S).getLexicalForm());
    }

    public void testCreateBlankFromNode() {
        RDFNode S = this.model.getRDFNode(NodeCreateUtils.create("_Blank"));
        AbstractTestModel.assertInstanceOf(Resource.class, S);
        AbstractTestModel.assertEquals((Object)new AnonId("_Blank"), (Object)((Resource)S).getId());
    }

    public void testIsEmpty() {
        Statement S1 = AbstractTestModel.statement(this.model, "model rdf:type nonEmpty");
        Statement S2 = AbstractTestModel.statement(this.model, "pinky rdf:type Pig");
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
        this.model.add(S1);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.add(S2);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(S1);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(S2);
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
    }

    public void testContainsResource() {
        AbstractTestModel.modelAdd(this.model, "x R y; _a P _b");
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "x")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "R")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "y")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "_a")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "P")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "_b")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "i")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource((RDFNode)AbstractTestModel.resource(this.model, "_j")));
    }

    public void testGetProperty() {
        AbstractTestModel.modelAdd(this.model, "x P a; x P b; x R c");
        Resource x = AbstractTestModel.resource(this.model, "x");
        AbstractTestModel.assertEquals((Object)AbstractTestModel.resource(this.model, "c"), (Object)x.getProperty(AbstractTestModel.property(this.model, "R")).getObject());
        RDFNode ob = x.getProperty(AbstractTestModel.property(this.model, "P")).getObject();
        AbstractTestModel.assertTrue((ob.equals(AbstractTestModel.resource(this.model, "a")) || ob.equals(AbstractTestModel.resource(this.model, "b")) ? (byte)1 : 0) != 0);
        AbstractTestModel.assertNull((Object)x.getProperty(AbstractTestModel.property(this.model, "noSuchPropertyHere")));
    }

    public void testToStatement() {
        Triple t = AbstractTestModel.triple("a P b");
        Statement s = this.model.asStatement(t);
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("a"), (Object)s.getSubject().asNode());
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("P"), (Object)s.getPredicate().asNode());
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("b"), (Object)s.getObject().asNode());
    }

    public void testAsRDF() {
        this.testPresentAsRDFNode(AbstractTestModel.node("a"), Resource.class);
        this.testPresentAsRDFNode(AbstractTestModel.node("17"), Literal.class);
        this.testPresentAsRDFNode(AbstractTestModel.node("_b"), Resource.class);
    }

    private void testPresentAsRDFNode(Node n, Class<? extends RDFNode> nodeClass) {
        RDFNode r = this.model.asRDFNode(n);
        AbstractTestModel.assertSame((Object)n, (Object)r.asNode());
        AbstractTestModel.assertInstanceOf(nodeClass, r);
    }

    public void testURINodeAsResource() {
        Node n = AbstractTestModel.node("a");
        Resource r = this.model.wrapAsResource(n);
        AbstractTestModel.assertSame((Object)n, (Object)r.asNode());
    }

    public void testLiteralNodeAsResourceFails() {
        try {
            this.model.wrapAsResource(AbstractTestModel.node("17"));
            AbstractTestModel.fail((String)"should fail to convert literal to Resource");
        }
        catch (UnsupportedOperationException e) {
            AbstractTestModel.pass();
        }
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a RR b");
        this.testRemoveAll("x P y; a Q b; c R 17; _d S 'e'");
        this.testRemoveAll("subject Predicate 'object'; http://nowhere/x scheme:cunning not:plan");
    }

    protected void testRemoveAll(String statements) {
        AbstractTestModel.modelAdd(this.model, statements);
        AbstractTestModel.assertSame((Object)this.model, (Object)this.model.removeAll());
        AbstractTestModel.assertEquals((String)"model should have size 0 following removeAll(): ", (long)0L, (long)this.model.size());
    }

    public void testRemoveSPO() {
        ModelCom mc = (ModelCom)ModelFactory.createDefaultModel();
        for (int i = 0; i < this.cases.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Model content = this.getModel();
                Model baseContent = this.copy(content);
                AbstractTestModel.modelAdd(content, this.cases[i][0]);
                Triple remove = AbstractTestModel.triple(this.cases[i][1]);
                Node s = remove.getSubject();
                Node p = remove.getPredicate();
                Node o = remove.getObject();
                Resource S = (Resource)(s.equals((Object)Node.ANY) ? null : mc.getRDFNode(s));
                Property P = p.equals((Object)Node.ANY) ? null : (Property)mc.getRDFNode(p).as(Property.class);
                RDFNode O = o.equals((Object)Node.ANY) ? null : mc.getRDFNode(o);
                Model expected = AbstractTestModel.modelWithStatements(this.cases[i][2]);
                content.removeAll(S, P, O);
                Model finalContent = this.copy(content).remove(baseContent);
                AbstractTestModel.assertIsoModels(this.cases[i][1], expected, finalContent);
            }
        }
    }

    public void testIsClosedDelegatedToGraph() {
        Model m = this.getModel();
        AbstractTestModel.assertFalse((boolean)m.isClosed());
        m.close();
        AbstractTestModel.assertTrue((boolean)m.isClosed());
    }

    protected Model copy(Model m) {
        return ModelFactory.createDefaultModel().add(m);
    }
}

