/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states;

import com.hp.hpl.jena.rdf.arp.impl.Taint;
import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.states.AttrEvent;
import com.hp.hpl.jena.rdf.arp.states.Event;
import com.hp.hpl.jena.rdf.arp.states.FrameI;
import com.hp.hpl.jena.rdf.arp.states.QName;
import com.hp.hpl.jena.rdf.arp.states.TestData;
import junit.framework.Assert;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventList
implements Attributes,
Cloneable {
    Event[] events = new Event[20];
    int size = 0;
    int pos = 0;
    boolean testException;
    boolean testFailure;
    FrameI testResult;
    boolean rethrowException;
    boolean failOnError;

    boolean hasNext() {
        return this.pos < this.size;
    }

    Event next() {
        return this.events[this.pos++];
    }

    Event peek() {
        return this.events[this.pos];
    }

    Event last() {
        return this.events[this.size - 1];
    }

    void clear() {
        this.size = 0;
        this.pos = 0;
    }

    void pop() {
        --this.size;
        this.events[this.size] = null;
    }

    void rewind() {
        this.pos = 0;
    }

    void skipAttrs() {
        this.pos += this.getLength();
    }

    void add(Event e) {
        this.events[this.size++] = e;
    }

    public EventList() {
    }

    public EventList(String[] ev) {
        for (int i = 0; i < ev.length; ++i) {
            this.add(TestData.short2Event.get(ev[i]));
        }
    }

    public EventList copy() {
        try {
            EventList rslt = (EventList)this.clone();
            rslt.events = (Event[])rslt.events.clone();
            return rslt;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int getLength() {
        int sz = 0;
        while (this.pos + sz < this.size && this.events[this.pos + sz].isAttribute()) {
            ++sz;
        }
        return sz;
    }

    private QName q(int i) {
        return ((AttrEvent)this.events[this.pos + i]).q;
    }

    @Override
    public String getURI(int index) {
        return this.q((int)index).uri;
    }

    @Override
    public String getLocalName(int index) {
        return this.q((int)index).localName;
    }

    @Override
    public String getQName(int index) {
        return this.q((int)index).qName;
    }

    @Override
    public String getType(int index) {
        return null;
    }

    @Override
    public String getValue(int index) {
        return ((AttrEvent)this.events[this.pos + index]).value;
    }

    @Override
    public int getIndex(String uri, String localName) {
        return -1;
    }

    @Override
    public int getIndex(String qName) {
        return -1;
    }

    @Override
    public String getType(String uri, String localName) {
        return null;
    }

    @Override
    public String getType(String qName) {
        return null;
    }

    @Override
    public String getValue(String uri, String localName) {
        return null;
    }

    @Override
    public String getValue(String qName) {
        return null;
    }

    public void delete(int i) {
        System.arraycopy(this.events, i + 1, this.events, i, this.size - 1 - i);
        --this.size;
    }

    boolean test(Class<? extends FrameI> cl) {
        try {
            this.testException = false;
            this.testFailure = true;
            FrameI frame = TestData.create(cl);
            TestData.xmlHandler.clear(this.failOnError);
            TestData.testFrame.clear();
            this.rewind();
            if (frame == null) {
                Assert.fail((String)"Frame is null");
            }
            frame.getXMLContext().getLang((Taint)new TaintImpl());
            while (this.hasNext()) {
                Event ev = this.next();
                frame = ev.apply(frame, this);
                this.skipAttrs();
                if (TestData.xmlHandler.wrong) {
                    return false;
                }
                if (frame != TestData.testFrame) continue;
                return false;
            }
            this.testResult = frame;
            this.testFailure = false;
            return true;
        }
        catch (RuntimeException e) {
            this.testException = true;
            if (this.rethrowException) {
                throw e;
            }
            return false;
        }
        catch (Exception e) {
            this.testException = true;
            if (this.rethrowException) {
                throw new RuntimeException(e);
            }
            e.printStackTrace();
            return false;
        }
    }

    public void expectAnError(boolean b) {
        this.failOnError = !b;
    }

    public void expectAnException(boolean b) {
        this.rethrowException = !b;
    }
}

