/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.OntTestBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestProperty
extends OntTestBase {
    public static TestSuite suite() {
        return new TestProperty("TestProperty");
    }

    public TestProperty(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("OntProperty.super-property", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addSuperProperty((Property)q);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.SUB_PROPERTY_OF()));
                1.assertEquals((String)"p have super-prop q", (Object)q, (Object)p.getSuperProperty());
                p.addSuperProperty((Property)r);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)p.getCardinality(prof.SUB_PROPERTY_OF()));
                this.iteratorTest((Iterator<?>)p.listSuperProperties(), new Object[]{q, r});
                p.setSuperProperty((Property)r);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.SUB_PROPERTY_OF()));
                1.assertEquals((String)"p shuold have super-prop r", (Object)r, (Object)p.getSuperProperty());
                p.removeSuperProperty((Property)q);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.SUB_PROPERTY_OF()));
                p.removeSuperProperty((Property)r);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)p.getCardinality(prof.SUB_PROPERTY_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.sub-property", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntProperty q = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#q");
                OntProperty r = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addSubProperty((Property)q);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)q.getCardinality(prof.SUB_PROPERTY_OF()));
                2.assertEquals((String)"p have sub-prop q", (Object)q, (Object)p.getSubProperty());
                p.addSubProperty((Property)r);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)(q.getCardinality(prof.SUB_PROPERTY_OF()) + r.getCardinality(prof.SUB_PROPERTY_OF())));
                this.iteratorTest((Iterator<?>)p.listSubProperties(), new Object[]{q, r});
                this.iteratorTest((Iterator<?>)q.listSuperProperties(), new Object[]{p});
                this.iteratorTest((Iterator<?>)r.listSuperProperties(), new Object[]{p});
                p.setSubProperty((Property)r);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)(q.getCardinality(prof.SUB_PROPERTY_OF()) + r.getCardinality(prof.SUB_PROPERTY_OF())));
                2.assertEquals((String)"p should have sub-prop r", (Object)r, (Object)p.getSubProperty());
                p.removeSubProperty((Property)q);
                2.assertTrue((String)"Should have sub-prop r", (boolean)p.hasSubProperty((Property)r, false));
                p.removeSubProperty((Property)r);
                2.assertTrue((String)"Should not have sub-prop r", (!p.hasSubProperty((Property)r, false) ? (byte)1 : 0) != 0);
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                p.addDomain((Resource)a);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.DOMAIN()));
                3.assertEquals((String)"p have domain a", (Object)a, (Object)p.getDomain());
                p.addDomain((Resource)b);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)p.getCardinality(prof.DOMAIN()));
                this.iteratorTest((Iterator<?>)p.listDomain(), new Object[]{a, b});
                p.setDomain((Resource)b);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.DOMAIN()));
                3.assertEquals((String)"p should have domain b", (Object)b, (Object)p.getDomain());
                p.removeDomain((Resource)a);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.DOMAIN()));
                p.removeDomain((Resource)b);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)p.getCardinality(prof.DOMAIN()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                OntProperty p = m.createOntProperty("http://jena.hpl.hp.com/testing/ontology#p");
                OntResource a = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#a").as(OntResource.class);
                OntResource b = (OntResource)m.getResource("http://jena.hpl.hp.com/testing/ontology#b").as(OntResource.class);
                p.addRange((Resource)a);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.RANGE()));
                4.assertEquals((String)"p have range a", (Object)a, (Object)p.getRange());
                p.addRange((Resource)b);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)p.getCardinality(prof.RANGE()));
                this.iteratorTest((Iterator<?>)p.listRange(), new Object[]{a, b});
                p.setRange((Resource)b);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.RANGE()));
                4.assertEquals((String)"p should have range b", (Object)b, (Object)p.getRange());
                p.removeRange((Resource)a);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.RANGE()));
                p.removeRange((Resource)b);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)p.getCardinality(prof.RANGE()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                p.addEquivalentProperty((Property)q);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                5.assertEquals((String)"p have equivalentProperty q", (Object)q, (Object)p.getEquivalentProperty());
                p.addEquivalentProperty((Property)r);
                5.assertEquals((String)"Cardinality should be 2", (int)2, (int)p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                this.iteratorTest((Iterator<?>)p.listEquivalentProperties(), new Object[]{q, r});
                p.setEquivalentProperty((Property)r);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                5.assertEquals((String)"p should have equivalentProperty r", (Object)r, (Object)p.getEquivalentProperty());
                p.removeEquivalentProperty((Property)q);
                5.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.EQUIVALENT_PROPERTY()));
                p.removeEquivalentProperty((Property)r);
                5.assertEquals((String)"Cardinality should be 0", (int)0, (int)p.getCardinality(prof.EQUIVALENT_PROPERTY()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inverseOf", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                6.assertFalse((boolean)p.isInverseOf((Property)q));
                6.assertEquals(null, (Object)p.getInverseOf());
                p.addInverseOf((Property)q);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.INVERSE_OF()));
                6.assertEquals((String)"p should have inverse q", (Object)q, (Object)p.getInverseOf());
                p.addInverseOf((Property)r);
                6.assertEquals((String)"Cardinality should be 2", (int)2, (int)p.getCardinality(prof.INVERSE_OF()));
                this.iteratorTest((Iterator<?>)p.listInverseOf(), new Object[]{q, r});
                p.setInverseOf((Property)r);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.INVERSE_OF()));
                6.assertEquals((String)"p should have inverse r", (Object)r, (Object)p.getInverseOf());
                p.removeInverseProperty((Property)q);
                6.assertEquals((String)"Cardinality should be 1", (int)1, (int)p.getCardinality(prof.INVERSE_OF()));
                p.removeInverseProperty((Property)r);
                6.assertEquals((String)"Cardinality should be 0", (int)0, (int)p.getCardinality(prof.INVERSE_OF()));
            }
        }, new OntTestBase.OntTestCase("OntProperty.subproperty.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(OntProperty.class);
                OntProperty q = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "q").as(OntProperty.class);
                this.iteratorTest((Iterator<?>)p.listSuperProperties(), new Object[]{q});
                this.iteratorTest((Iterator<?>)q.listSubProperties(), new Object[]{p});
            }
        }, new OntTestBase.OntTestCase("OntProperty.domain.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(OntProperty.class);
                OntClass A = (OntClass)m.getResource("http://jena.hpl.hp.com/testing/ontology#ClassA").as(OntClass.class);
                8.assertTrue((String)"p should have domain A", (boolean)p.hasDomain((Resource)A));
            }
        }, new OntTestBase.OntTestCase("OntProperty.range.fromFile", true, true, true, true){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(OntProperty.class);
                OntClass B = (OntClass)m.getResource("http://jena.hpl.hp.com/testing/ontology#ClassB").as(OntClass.class);
                9.assertTrue((String)"p should have domain B", (boolean)p.hasRange((Resource)B));
            }
        }, new OntTestBase.OntTestCase("OntProperty.equivalentProeprty.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(OntProperty.class);
                OntProperty r = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "r").as(OntProperty.class);
                10.assertTrue((String)"p should have equiv prop r", (boolean)p.hasEquivalentProperty((Property)r));
            }
        }, new OntTestBase.OntTestCase("OntProperty.inversePropertyOf.fromFile", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                String lang = this.m_owlLang ? "owl" : (this.m_damlLang ? "daml" : "rdfs");
                String fileName = "file:testing/ontology/" + lang + "/Property/test.rdf";
                m.read(fileName);
                OntProperty p = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "p").as(OntProperty.class);
                OntProperty s = (OntProperty)m.getProperty("http://jena.hpl.hp.com/testing/ontology#", "s").as(OntProperty.class);
                11.assertTrue((String)"p should have inv prop s", (boolean)p.isInverseOf((Property)s));
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty dt", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                12.assertTrue((String)"isFunctionalProperty not correct", (boolean)p.isFunctionalProperty());
                12.assertTrue((String)"isDatatypeProperty not correct", (boolean)p.isDatatypeProperty());
                12.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                12.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                12.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    12.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isFunctionalProperty object", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", true);
                13.assertTrue((String)"isFunctionalProperty not correct", (boolean)p.isFunctionalProperty());
                13.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                13.assertTrue((String)"isObjectProperty not correct", (boolean)p.isObjectProperty());
                13.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                13.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    13.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                DatatypeProperty p = m.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                14.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                14.assertTrue((String)"isDatatypeProperty not correct", (boolean)p.isDatatypeProperty());
                14.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                14.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                14.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    14.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p", false);
                15.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                15.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                15.assertTrue((String)"isObjectProperty not correct", (boolean)p.isObjectProperty());
                15.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                15.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    15.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                TransitiveProperty p = m.createTransitiveProperty("http://jena.hpl.hp.com/testing/ontology#p");
                16.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                16.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                16.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                16.assertTrue((String)"isTransitiveProperty not correct", (boolean)p.isTransitiveProperty());
                16.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    16.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                InverseFunctionalProperty p = m.createInverseFunctionalProperty("http://jena.hpl.hp.com/testing/ontology#p");
                17.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                17.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                17.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                17.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                17.assertTrue((String)"isInverseFunctionalProperty not correct", (boolean)p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    17.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.isSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                SymmetricProperty p = m.createSymmetricProperty("http://jena.hpl.hp.com/testing/ontology#p");
                18.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                18.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                18.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                18.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                18.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    18.assertTrue((String)"isSymmetricProperty not correct", (boolean)p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                19.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    19.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                p = p.convertToFunctionalProperty();
                19.assertTrue((String)"isFunctionalProperty not correct", (boolean)p.isFunctionalProperty());
                19.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                19.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    19.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToDatatypeProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                20.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    20.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                20.assertTrue((String)"isFunctionalProperty not correct", (!(p = p.convertToDatatypeProperty()).isFunctionalProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isDatatypeProperty not correct", (boolean)p.isDatatypeProperty());
                20.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                20.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    20.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToObjectProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                21.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    21.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                21.assertTrue((String)"isFunctionalProperty not correct", (!(p = p.convertToObjectProperty()).isFunctionalProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isObjectProperty not correct", (boolean)p.isObjectProperty());
                21.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                21.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    21.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToTransitiveProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                22.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    22.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                22.assertTrue((String)"isFunctionalProperty not correct", (!(p = p.convertToTransitiveProperty()).isFunctionalProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                22.assertTrue((String)"isTransitiveProperty not correct", (boolean)p.isTransitiveProperty());
                22.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    22.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToInverseFunctionalProperty", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                23.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    23.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                23.assertTrue((String)"isFunctionalProperty not correct", (!(p = p.convertToInverseFunctionalProperty()).isFunctionalProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                23.assertTrue((String)"isInverseFunctionalProperty not correct", (boolean)p.isInverseFunctionalProperty());
                if (this.m_owlLang) {
                    23.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
            }
        }, new OntTestBase.OntTestCase("OntProperty.convertToSymmetricProperty", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Property pSimple = m.createProperty("http://jena.hpl.hp.com/testing/ontology#", "p");
                pSimple.addProperty(RDF.type, (RDFNode)RDF.Property);
                OntProperty p = (OntProperty)pSimple.as(OntProperty.class);
                24.assertTrue((String)"isFunctionalProperty not correct", (!p.isFunctionalProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    24.assertTrue((String)"isSymmetricProperty not correct", (!p.isSymmetricProperty() ? (byte)1 : 0) != 0);
                }
                24.assertTrue((String)"isFunctionalProperty not correct", (!(p = p.convertToSymmetricProperty()).isFunctionalProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isDatatypeProperty not correct", (!p.isDatatypeProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isObjectProperty not correct", (!p.isObjectProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isTransitiveProperty not correct", (!p.isTransitiveProperty() ? (byte)1 : 0) != 0);
                24.assertTrue((String)"isInverseFunctionalProperty not correct", (!p.isInverseFunctionalProperty() ? (byte)1 : 0) != 0);
                if (this.m_owlLang) {
                    24.assertTrue((String)"isSymmetricProperty not correct", (boolean)p.isSymmetricProperty());
                }
            }
        }, new OntTestBase.OntTestCase("ObjectProperty.inverse", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                ObjectProperty r = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#r");
                25.assertFalse((String)"No inverse of p", (boolean)p.hasInverse());
                25.assertEquals(null, (Object)p.getInverse());
                q.addInverseOf((Property)p);
                25.assertTrue((String)"Inverse of p", (boolean)p.hasInverse());
                25.assertEquals((String)"inverse of p ", (Object)q, (Object)p.getInverse());
                r.addInverseOf((Property)p);
                this.iteratorTest((Iterator<?>)p.listInverse(), new Object[]{q, r});
            }
        }, new OntTestBase.OntTestCase("OntProperty.listReferringRestrictions", true, true, true, false){

            protected void ontTest(OntModel m) throws Exception {
                ObjectProperty p = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
                ObjectProperty q = m.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#q");
                CardinalityRestriction r0 = m.createCardinalityRestriction(null, (Property)p, 2);
                CardinalityRestriction r1 = m.createCardinalityRestriction(null, (Property)p, 3);
                CardinalityRestriction r2 = m.createCardinalityRestriction(null, (Property)q, 2);
                CardinalityRestriction r3 = m.createCardinalityRestriction(null, (Property)q, 3);
                26.assertTrue((boolean)this.iteratorContains((Iterator<?>)p.listReferringRestrictions(), r0));
                26.assertTrue((boolean)this.iteratorContains((Iterator<?>)p.listReferringRestrictions(), r1));
                26.assertFalse((boolean)this.iteratorContains((Iterator<?>)p.listReferringRestrictions(), r2));
                26.assertFalse((boolean)this.iteratorContains((Iterator<?>)p.listReferringRestrictions(), r3));
                26.assertNotNull((Object)p.listReferringRestrictions().next());
            }
        }};
    }
}

