/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestListSyntaxCategories
extends TestCase {
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static DoListTest[] testCases = new DoListTest[]{new DoListTest("OWL list ontologies", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntologies();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Ontology;
        }
    }, new DoListTest("DAML list ontologies", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntologies();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Ontology;
        }
    }, new DoListTest("OWL list properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#p", "http://jena.hpl.hp.com/testing/ontology#karma"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#p"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list object properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listObjectProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list datatype properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listDatatypeProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list functional properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#fp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listFunctionalProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof FunctionalProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list transitive properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#tp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listTransitiveProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof TransitiveProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list symmetric properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#sp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listSymmetricProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof SymmetricProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list inverse functional properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#ifp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listInverseFunctionalProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof InverseFunctionalProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 5, new String[]{"http://jena.hpl.hp.com/testing/ontology#p", "http://jena.hpl.hp.com/testing/ontology#rdf-p", "http://jena.hpl.hp.com/testing/ontology#dp", "http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list object properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listObjectProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list datatype properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listDatatypeProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list functional properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#fp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listFunctionalProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof FunctionalProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list transitive properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#tp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listTransitiveProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof TransitiveProperty && r instanceof Property;
        }
    }, new DoListTest("DAML list inverse functional properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#ifp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listInverseFunctionalProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof InverseFunctionalProperty && r instanceof Property;
        }
    }, new DoListTest("OWL list individuals", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 8, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0", "http://jena.hpl.hp.com/testing/ontology#a0", "http://jena.hpl.hp.com/testing/ontology#a1", "http://jena.hpl.hp.com/testing/ontology#a2", "http://jena.hpl.hp.com/testing/ontology#z0", "http://jena.hpl.hp.com/testing/ontology#z1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list typed individuals", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            Model mVocab = ModelFactory.createDefaultModel();
            Resource cA = mVocab.createResource("http://jena.hpl.hp.com/testing/ontology#A");
            return m.listIndividuals(cA);
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list individuals negative case 1", null, OntModelSpec.OWL_MEM, 0, new String[0]){

        @Override
        protected void addAxioms(OntModel m) {
            m.add(m.createResource("http://jena.hpl.hp.com/testing/ontology#A0"), RDF.type, (RDFNode)OWL.Class);
        }

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list individuals negative case 2", null, OntModelSpec.OWL_MEM_MICRO_RULE_INF, 0, new String[0]){

        @Override
        protected void addAxioms(OntModel m) {
            m.add(m.createResource("http://jena.hpl.hp.com/testing/ontology#A0"), RDF.type, (RDFNode)OWL.Class);
        }

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list individuals negative case 3", null, OntModelSpec.OWL_MEM, 0, new String[0]){

        @Override
        protected void addAxioms(OntModel m) {
            Resource a0 = m.createResource("http://jena.hpl.hp.com/testing/ontology#A0");
            m.add(a0, RDF.type, (RDFNode)OWL.Class);
            m.add(OWL.Class, RDF.type, (RDFNode)OWL.Class);
        }

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list individuals negative case 4", null, OntModelSpec.OWL_MEM, 0, new String[0]){

        @Override
        protected void addAxioms(OntModel m) {
            Resource a0 = m.createResource("http://jena.hpl.hp.com/testing/ontology#A0");
            m.add(a0, RDF.type, (RDFNode)OWL.Class);
            m.add(OWL.Class, RDF.type, (RDFNode)RDFS.Class);
        }

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list individuals - punning", null, OntModelSpec.OWL_MEM, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0"}){

        @Override
        protected void addAxioms(OntModel m) {
            Resource a0 = m.createResource("http://jena.hpl.hp.com/testing/ontology#A0");
            Resource a1 = m.createResource("http://jena.hpl.hp.com/testing/ontology#A1");
            m.add(a0, RDF.type, (RDFNode)OWL.Class);
            m.add(a1, RDF.type, (RDFNode)OWL.Class);
            m.add(a0, RDF.type, (RDFNode)a1);
        }

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("empty OWL list individuals", null, OntModelSpec.OWL_MEM, 0, new String[0]){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("empty OWL+rule list individuals", null, OntModelSpec.OWL_MEM_RULE_INF, 0, new String[0]){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("DAML list individuals", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 6, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0", "http://jena.hpl.hp.com/testing/ontology#a1", "http://jena.hpl.hp.com/testing/ontology#a2", "http://jena.hpl.hp.com/testing/ontology#a0"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("empty DAML+rule list individuals", null, OntModelSpec.DAML_MEM_RULE_INF, 0, new String[0]){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL list all different", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listAllDifferent();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof AllDifferent;
        }
    }, new DoListTest("DAML list all different", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 0, null, true){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listAllDifferent();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof AllDifferent;
        }
    }, new DoListTest("OWL list classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list named classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 10, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listNamedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list intersection classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIntersectionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list union classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listUnionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list complement classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listComplementClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list enumerated classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listEnumeratedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL list restrictions", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listRestrictions();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Restriction;
        }
    }, new DoListTest("DAML list classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 12, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", DAML_OIL.Thing.getURI()}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list named classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", DAML_OIL.Thing.getURI()}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listNamedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list intersection classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIntersectionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list union classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listUnionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list complement classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listComplementClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list enumerated classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listEnumeratedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("DAML list restrictions", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listRestrictions();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Restriction;
        }
    }, new DoListTest("OWL list annotation properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listAnnotationProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof AnnotationProperty;
        }
    }, new DoListTest("OWL+import list ontologies", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology", "http://www.w3.org/2002/07/owl"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntologies();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Ontology;
        }
    }, new DoListTest("OWL+import list properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 46, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listOntProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL+import list object properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listObjectProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL+import list datatype properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listDatatypeProperties();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntProperty && r instanceof Property;
        }
    }, new DoListTest("OWL+import list individuals", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 8, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIndividuals();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Individual;
        }
    }, new DoListTest("OWL+import list all different", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listAllDifferent();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof AllDifferent;
        }
    }, new DoListTest("OWL+import list classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 14, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list named classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 12, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", OWL.Thing.getURI(), OWL.Nothing.getURI()}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listNamedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list intersection classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listIntersectionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list union classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#B", OWL.Thing.getURI()}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listUnionClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list complement classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 3, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listComplementClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list enumerated classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listEnumeratedClasses();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof OntClass;
        }
    }, new DoListTest("OWL+import list restrictions", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        @Override
        public Iterator<? extends Resource> doList(OntModel m) {
            return m.listRestrictions();
        }

        @Override
        public boolean test(Resource r) {
            return r instanceof Restriction;
        }
    }};

    public TestListSyntaxCategories(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite s = new TestSuite("TestListSyntaxCategories");
        for (int i = 0; i < testCases.length; ++i) {
            s.addTest((Test)testCases[i]);
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DoListTest
    extends TestCase {
        protected String m_fileName;
        protected OntModelSpec m_spec;
        protected int m_count;
        protected String[] m_expected;
        protected boolean m_exExpected;

        protected DoListTest(String name, String fileName, OntModelSpec spec, int count, String[] expected) {
            this(name, fileName, spec, count, expected, false);
        }

        protected DoListTest(String name, String fileName, OntModelSpec spec, int count, String[] expected, boolean exExpected) {
            super(name);
            this.m_fileName = fileName;
            this.m_spec = spec;
            this.m_count = count;
            this.m_expected = expected;
            this.m_exExpected = exExpected;
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }

        public void runTest() {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)this.m_spec, null);
            m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
            if (this.m_fileName != null) {
                m.read(this.m_fileName);
            }
            this.addAxioms(m);
            boolean exOccurred = false;
            Iterator<? extends Resource> i = null;
            try {
                i = this.doList(m);
            }
            catch (OntologyException e) {
                exOccurred = true;
            }
            DoListTest.assertEquals((String)("Ontology exception" + (this.m_exExpected ? " was " : " was not ") + "expected"), (boolean)this.m_exExpected, (boolean)exOccurred);
            if (!exOccurred) {
                Iterator<Object> j;
                List<Resource> expected = this.expected(m);
                ArrayList<Resource> actual = new ArrayList<Resource>();
                int extraneous = 0;
                while (i.hasNext()) {
                    Resource res = i.next();
                    DoListTest.assertTrue((String)("Should not fail node test on " + res), (boolean)this.test(res));
                    actual.add(res);
                    if (expected == null) continue;
                    if (expected.contains(res)) {
                        expected.remove(res);
                        continue;
                    }
                    if (res.isAnon()) continue;
                    ++extraneous;
                    logger.debug("found extraneous result: " + res);
                }
                if (this.m_count != actual.size()) {
                    logger.debug(this.getName() + " - expected " + this.m_count + " results, actual = " + actual.size());
                    j = actual.iterator();
                    while (j.hasNext()) {
                        logger.debug(this.getName() + " - saw actual: " + j.next());
                    }
                }
                if (expected != null && !expected.isEmpty()) {
                    j = expected.iterator();
                    while (j.hasNext()) {
                        logger.debug(this.getName() + " - expected but did not find: " + j.next());
                    }
                }
                DoListTest.assertEquals((String)(this.getName() + ": wrong number of results returned"), (int)this.m_count, (int)actual.size());
                if (expected != null) {
                    DoListTest.assertTrue((String)"Did not find all expected resources in iterator", (boolean)expected.isEmpty());
                    DoListTest.assertEquals((String)"Found extraneous results, not in expected list", (int)0, (int)extraneous);
                }
            }
        }

        public Iterator<? extends Resource> doList(OntModel m) {
            return null;
        }

        public boolean test(Resource r) {
            return true;
        }

        protected List<Resource> expected(OntModel m) {
            if (this.m_expected != null) {
                ArrayList<Resource> expected = new ArrayList<Resource>();
                for (int i = 0; i < this.m_expected.length; ++i) {
                    expected.add(m.getResource(this.m_expected[i]));
                }
                return expected;
            }
            return null;
        }

        protected void addAxioms(OntModel m) {
        }
    }
}

