/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import junit.framework.TestCase;

public class TestFrameView
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    OntModel mInf;
    OntModel mNoInf;
    OntClass infA;
    OntClass infB;
    OntClass infC;
    OntClass noinfA;
    OntClass noinfB;
    OntClass noinfC;
    ObjectProperty noinfG;
    ObjectProperty infG;
    ObjectProperty noinfPa;
    ObjectProperty noinfPb;
    ObjectProperty noinfPc;
    ObjectProperty infPa;
    ObjectProperty infPb;
    ObjectProperty infPc;
    ObjectProperty noinfQa;
    ObjectProperty noinfQb;
    ObjectProperty infQa;
    ObjectProperty infQb;
    OntClass infAnn;
    OntClass noinfAnn;
    AnnotationProperty infPann;
    AnnotationProperty noinfPann;
    OntClass infUnion1;
    OntClass infUnion2;
    OntClass noinfUnion1;
    OntClass noinfUnion2;
    ObjectProperty infPunion;
    ObjectProperty noinfPunion;
    OntClass infIntersect1;
    OntClass infIntersect2;
    OntClass noinfIntersect1;
    OntClass noinfIntersect2;
    ObjectProperty infPintersect;
    ObjectProperty noinfPintersect;

    public void setUp() {
        OntDocumentManager.getInstance().reset();
        OntDocumentManager.getInstance().clearCache();
        this.mNoInf = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        this.mNoInf.read("file:testing/ontology/owl/list-syntax/test-ldp.rdf");
        this.mInf = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        this.mInf.read("file:testing/ontology/owl/list-syntax/test-ldp.rdf");
        this.infA = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#A");
        this.infB = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#B");
        this.infC = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#C");
        this.noinfA = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#A");
        this.noinfB = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#B");
        this.noinfC = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#C");
        this.noinfG = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#global");
        this.infG = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#global");
        this.noinfPa = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pA");
        this.noinfPb = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pB");
        this.noinfPc = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pC");
        this.infPa = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pA");
        this.infPb = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pB");
        this.infPc = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#pC");
        this.noinfQa = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#qA");
        this.noinfQb = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#qB");
        this.infQa = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#qA");
        this.infQb = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#qB");
        this.infAnn = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#HasAnn");
        this.noinfAnn = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#HasAnn");
        this.infPann = this.mInf.getAnnotationProperty("http://jena.hpl.hp.com/testing/ontology#ann");
        this.noinfPann = this.mNoInf.getAnnotationProperty("http://jena.hpl.hp.com/testing/ontology#ann");
        this.infUnion1 = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Union1");
        this.infUnion2 = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Union2");
        this.noinfUnion1 = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Union1");
        this.noinfUnion2 = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Union2");
        this.infPunion = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#unionP");
        this.noinfPunion = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#unionP");
        this.infIntersect1 = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Intersect1");
        this.infIntersect2 = this.mInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Intersect2");
        this.noinfIntersect1 = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Intersect1");
        this.noinfIntersect2 = this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Intersect2");
        this.infPintersect = this.mInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#intersectP");
        this.noinfPintersect = this.mNoInf.getObjectProperty("http://jena.hpl.hp.com/testing/ontology#intersectP");
    }

    public void tearDown() {
        this.mInf.close();
        this.mInf = null;
        this.mNoInf.close();
        this.mNoInf = null;
    }

    public void testLDP_noinfA_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfA.listDeclaredProperties(false), new Object[]{this.noinfPa, this.noinfQa, this.noinfG, this.noinfQb});
    }

    public void testHasDP_noinfA_nodirect() {
        TestFrameView.assertTrue((boolean)this.noinfA.hasDeclaredProperty((Property)this.noinfPa, false));
        TestFrameView.assertFalse((boolean)this.noinfA.hasDeclaredProperty((Property)this.noinfPb, false));
    }

    public void testLDP_noinfA_direct() {
        TestUtil.assertIteratorValues(this, this.noinfA.listDeclaredProperties(true), new Object[]{this.noinfPa, this.noinfQa, this.noinfG, this.noinfQb});
    }

    public void testLDP_infA_nodirect() {
        TestUtil.assertIteratorValues(this, this.infA.listDeclaredProperties(false), new Object[]{this.infPa, this.infQa, this.infQb, this.noinfG});
    }

    public void testLDP_infA_direct() {
        TestUtil.assertIteratorValues(this, this.infA.listDeclaredProperties(true), new Object[]{this.infPa, this.infQa, this.infQb, this.noinfG});
    }

    public void testLDP_noinfB_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfB.listDeclaredProperties(false), new Object[]{this.noinfPa, this.noinfPb, this.noinfQa, this.noinfG, this.noinfQb});
    }

    public void testLDP_noinfB_direct() {
        TestUtil.assertIteratorValues(this, this.noinfB.listDeclaredProperties(true), new Object[]{this.noinfPb});
    }

    public void testLDP_infB_nodirect() {
        TestUtil.assertIteratorValues(this, this.infB.listDeclaredProperties(false), new Object[]{this.infPa, this.infPb, this.infQa, this.infQb, this.infG});
    }

    public void testLDP_infB_direct() {
        TestUtil.assertIteratorValues(this, this.infB.listDeclaredProperties(true), new Object[]{this.infPb});
    }

    public void testLDP_noinfC_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfC.listDeclaredProperties(false), new Object[]{this.noinfPa, this.noinfPb, this.noinfPc, this.noinfQa, this.noinfG, this.noinfQb});
    }

    public void testLDP_noinfC_direct() {
        TestUtil.assertIteratorValues(this, this.noinfC.listDeclaredProperties(true), new Object[]{this.noinfPc});
    }

    public void testLDP_infC_nodirect() {
        TestUtil.assertIteratorValues(this, this.infC.listDeclaredProperties(false), new Object[]{this.infPa, this.infPb, this.infPc, this.infQa, this.infQb, this.infG});
    }

    public void testLDP_infC_direct() {
        TestUtil.assertIteratorValues(this, this.infC.listDeclaredProperties(true), new Object[]{this.infPc});
    }

    public void testLDP_noinfAnn_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfAnn.listDeclaredProperties(false), new Object[]{this.noinfPann, this.noinfG, this.noinfQb});
    }

    public void testLDP_noinfAnn_direct() {
        TestUtil.assertIteratorValues(this, this.noinfAnn.listDeclaredProperties(true), new Object[]{this.noinfPann, this.noinfG, this.noinfQb});
    }

    public void testLDP_infAnn_nodirect() {
        TestUtil.assertIteratorValues(this, this.infAnn.listDeclaredProperties(false), new Object[]{this.noinfPann, this.noinfG});
    }

    public void testLDP_infAnn_direct() {
        TestUtil.assertIteratorValues(this, this.infAnn.listDeclaredProperties(true), new Object[]{this.noinfPann, this.noinfG});
    }

    public void testLDP_noinfUnion_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfUnion1.listDeclaredProperties(false), new Object[]{this.noinfG, this.noinfQb});
        TestUtil.assertIteratorValues(this, this.noinfUnion2.listDeclaredProperties(false), new Object[]{this.noinfG, this.noinfQb});
    }

    public void testLDP_infUnion_nodirect() {
        TestUtil.assertIteratorValues(this, this.infUnion1.listDeclaredProperties(false), new Object[]{this.infPunion, this.infG});
        TestUtil.assertIteratorValues(this, this.infUnion2.listDeclaredProperties(false), new Object[]{this.infPunion, this.infG});
    }

    public void testLDP_noinfIntersect_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfIntersect1.listDeclaredProperties(false), new Object[]{this.noinfG, this.noinfQb});
        TestUtil.assertIteratorValues(this, this.noinfIntersect2.listDeclaredProperties(false), new Object[]{this.noinfG, this.noinfQb});
    }

    public void testLDP_infIntersect_nodirect() {
        TestUtil.assertIteratorValues(this, this.infIntersect1.listDeclaredProperties(false), new Object[]{this.infG});
        TestUtil.assertIteratorValues(this, this.infIntersect2.listDeclaredProperties(false), new Object[]{this.infG});
    }

    public void testLDC_noinfPa_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfPa.listDeclaringClasses(false), new Object[]{this.noinfA, this.noinfB, this.noinfC});
    }

    public void testLDC_infPa_nodirect() {
        TestUtil.assertIteratorValues(this, this.infPa.listDeclaringClasses(false), new Object[]{this.infA, this.infB, this.infC});
    }

    public void testLDC_noinfPb_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfPb.listDeclaringClasses(false), new Object[]{this.noinfB, this.noinfC});
    }

    public void testLDC_infPb_nodirect() {
        TestUtil.assertIteratorValues(this, this.infPb.listDeclaringClasses(false), new Object[]{this.infC, this.infB});
    }

    public void testLDC_noinfPc_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfPc.listDeclaringClasses(false), new Object[]{this.noinfC});
    }

    public void testLDC_infPc_nodirect() {
        TestUtil.assertIteratorValues(this, this.infPc.listDeclaringClasses(false), new Object[]{this.infC});
    }

    public void testLDC_noinfPa_direct() {
        TestUtil.assertIteratorValues(this, this.noinfPa.listDeclaringClasses(true), new Object[]{this.noinfA});
    }

    public void testLDC_infPa_direct() {
        TestUtil.assertIteratorValues(this, this.infPa.listDeclaringClasses(true), new Object[]{this.infA});
    }

    public void testLDC_noinfPb_direct() {
        TestUtil.assertIteratorValues(this, this.noinfPb.listDeclaringClasses(true), new Object[]{this.noinfB});
    }

    public void testLDC_infPb_direct() {
        TestUtil.assertIteratorValues(this, this.infPb.listDeclaringClasses(true), new Object[]{this.infB});
    }

    public void testLDC_noinfPc_direct() {
        TestUtil.assertIteratorValues(this, this.noinfPc.listDeclaringClasses(true), new Object[]{this.noinfC});
    }

    public void testLDC_infPc_direct() {
        TestUtil.assertIteratorValues(this, this.infPc.listDeclaringClasses(true), new Object[]{this.infC});
    }

    public void testLDC_noinfG_direct() {
        TestUtil.assertIteratorValues(this, this.noinfG.listDeclaringClasses(true), new Object[]{this.noinfA, this.noinfAnn, this.noinfUnion1, this.noinfUnion2, this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Joint"), this.noinfIntersect1, this.noinfIntersect2}, 2);
    }

    public void testLDC_infG_direct() {
        TestUtil.assertIteratorValues(this, this.infG.listDeclaringClasses(true), new Object[]{this.infA, this.infAnn, this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Joint"), this.noinfIntersect1, this.noinfIntersect2}, 1);
    }

    public void testLDC_noinfG_nodirect() {
        TestUtil.assertIteratorValues(this, this.noinfG.listDeclaringClasses(false), new Object[]{this.noinfA, this.noinfB, this.noinfC, this.noinfUnion1, this.noinfUnion2, this.noinfAnn, this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Joint"), this.noinfIntersect1, this.noinfIntersect2}, 2);
    }

    public void testLDC_infG_nodirect() {
        TestUtil.assertIteratorValues(this, this.infG.listDeclaringClasses(false), new Object[]{this.infA, this.infB, this.infC, this.infAnn, this.noinfUnion1, this.noinfUnion2, this.mNoInf.getOntClass("http://jena.hpl.hp.com/testing/ontology#Joint"), this.noinfIntersect1, this.noinfIntersect2}, 2);
    }
}

