/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.mem.faster.GraphMemFasterQueryHandler;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelMakerImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.shared.ClosedException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class TestBugReports
extends TestCase {
    public static String NS = "http://example.org/test#";

    public TestBugReports(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
        OntDocumentManager.getInstance().setMetadataSearchPath("file:etc/ont-policy.rdf", false);
    }

    public void test_dn_0() {
        OntModel schema = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM_RULES_INF, null);
        schema.read("file:doc/inference/data/owlDemoSchema.xml", null);
        int count = 0;
        ExtendedIterator i = schema.listIndividuals();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        TestBugReports.assertEquals((String)"Expecting 6 individuals", (int)6, (int)count);
    }

    public void test_dn_01() {
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        m0.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty p0 = m0.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        int count = 0;
        ExtendedIterator i = p0.listDomain();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        TestBugReports.assertEquals((int)3, (int)count);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RULE_INF, null);
        m1.read("file:testing/ontology/bugs/test_hk_07B.owl");
        OntProperty p1 = m1.getOntProperty("file:testing/ontology/bugs/test_hk_07B.owl#PropB");
        count = 0;
        ExtendedIterator i2 = p1.listDomain();
        while (i2.hasNext()) {
            ++count;
            i2.next();
        }
        TestBugReports.assertEquals((int)3, (int)count);
    }

    public void test_dn_02() {
        OntModel mymod = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        mymod.read("file:testing/ontology/testImport3/a.owl");
        TestBugReports.assertEquals((String)"Graph count..", (int)2, (int)mymod.getSubGraphs().size());
        ExtendedIterator it = mymod.listSubModels();
        while (it.hasNext()) {
            mymod.removeSubModel((Model)it.next());
        }
        TestBugReports.assertEquals((String)"Graph count..", (int)0, (int)mymod.getSubGraphs().size());
    }

    public void test_mra_01() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM, null, null);
        String myDicURI = "http://somewhere/myDictionaries/1.0#";
        String damlURI = "http://www.daml.org/2001/03/daml+oil#";
        m.setNsPrefix("DAML", damlURI);
        String c1_uri = myDicURI + "C1";
        OntClass c1 = m.createClass(c1_uri);
        DatatypeProperty p1 = m.createDatatypeProperty(myDicURI + "P1");
        p1.setDomain((Resource)c1);
        ByteArrayOutputStream strOut = new ByteArrayOutputStream();
        m.write((OutputStream)strOut, "RDF/XML-ABBREV", myDicURI);
    }

    public void test_hk_01() {
        String base = "http://jena.hpl.hp.com/test#";
        String doc = "<rdf:RDF   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">  <owl:Ontology rdf:about=\"\">    <owl:imports rdf:resource=\"http://www.w3.org/2002/07/owl\" />  </owl:Ontology></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        m.read((InputStream)new ByteArrayInputStream(doc.getBytes()), base);
        Resource owlClassRes = m.getResource(OWL.Class.getURI());
        OntClass c = (OntClass)owlClassRes.as(OntClass.class);
        TestBugReports.assertNotNull((String)"OntClass c should not be null", (Object)c);
    }

    public void test_hk_02() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ontModel.createAllDifferent();
        TestBugReports.assertTrue((boolean)ontModel.listAllDifferent().hasNext());
        AllDifferent allDifferent = (AllDifferent)ontModel.listAllDifferent().next();
        TestBugReports.assertFalse((boolean)allDifferent.listDistinctMembers().hasNext());
    }

    public void test_hk_03() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ObjectProperty property = ontModel.createObjectProperty("http://www.aldi.de#property");
        ontModel.createMinCardinalityRestriction(null, (Property)property, 42);
    }

    public void test_hk_04() {
        OntModel m = ModelFactory.createOntologyModel();
        m.getDocumentManager().addAltEntry("http://jena.hpl.hp.com/testing/ontology/relativenames", "file:testing/ontology/relativenames.rdf");
        m.read("http://jena.hpl.hp.com/testing/ontology/relativenames");
        TestBugReports.assertTrue((String)"#A should be a class", (boolean)m.getResource("http://jena.hpl.hp.com/testing/ontology/relativenames#A").canAs(OntClass.class));
        TestBugReports.assertFalse((String)"file: #A should not be a class", (boolean)m.getResource("file:testing/ontology/relativenames.rdf#A").canAs(OntClass.class));
    }

    public void test_hk_05() {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        String ns = "http://foo.bar/fu#";
        OntClass a = ontModel.createClass(ns + "A");
        OntClass b = ontModel.createClass(ns + "B");
        int oldCount = this.getStatementCount(ontModel);
        RDFList members = ontModel.createList(new RDFNode[]{a, b});
        IntersectionClass intersectionClass = ontModel.createIntersectionClass(null, members);
        intersectionClass.remove();
        TestBugReports.assertEquals((String)"Before and after statement counts are different", (int)oldCount, (int)this.getStatementCount(ontModel));
    }

    public void test_hk_06() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        ontModel.read("file:testing/ontology/bugs/test_hk_06/a.owl");
        String NSa = "http://jena.hpl.hp.com/2003/03/testont/a#";
        String NSb = "http://jena.hpl.hp.com/2003/03/testont/b#";
        OntClass A = ontModel.getOntClass(NSa + "A");
        TestBugReports.assertTrue((String)"class A should be in the base model", (boolean)ontModel.isInBaseModel((RDFNode)A));
        OntClass B = ontModel.getOntClass(NSb + "B");
        TestBugReports.assertFalse((String)"class B should not be in the base model", (boolean)ontModel.isInBaseModel((RDFNode)B));
        TestBugReports.assertTrue((String)"A rdf:type owl:Class should be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)A, RDF.type, (RDFNode)OWL.Class)));
        TestBugReports.assertFalse((String)"B rdf:type owl:Class should not be in the base model", (boolean)ontModel.isInBaseModel(ontModel.createStatement((Resource)B, RDF.type, (RDFNode)OWL.Class)));
    }

    public void test_hk_07() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource c = m.createResource();
        c.addProperty(RDF.type, (RDFNode)RDFS.Datatype);
        TestBugReports.assertTrue((boolean)c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, (RDFNode)RDFS.Datatype);
        TestBugReports.assertTrue((boolean)c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, (RDFNode)RDFS.Datatype);
        TestBugReports.assertTrue((boolean)c.canAs(OntClass.class));
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM);
        c = m.createResource();
        c.addProperty(RDF.type, (RDFNode)RDFS.Datatype);
        TestBugReports.assertTrue((boolean)c.canAs(OntClass.class));
    }

    public void test_hk_importCache() {
        String BASE = "http://protege.stanford.edu/plugins/owl/testdata/";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        OntDocumentManager dm = OntDocumentManager.getInstance();
        dm.reset();
        dm.setCacheModels(false);
        dm.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/Import-normalizerBug.owl");
        dm.addAltEntry("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl", "file:testing/ontology/bugs/test_hk_import/normalizerBug.owl");
        spec.setDocumentManager(dm);
        OntModel oldOntModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        oldOntModel.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph oldSubGraph = (Graph)oldOntModel.getSubGraphs().iterator().next();
        int oldTripleCount = this.getTripleCount(oldSubGraph);
        OntClass ontClass = oldOntModel.getOntClass("http://protege.stanford.edu/plugins/owl/testdata/normalizerBug.owl#SuperClass");
        oldSubGraph.add(new Triple(ontClass.asNode(), RDF.type.asNode(), OWL.DeprecatedClass.asNode()));
        TestBugReports.assertEquals((int)(oldTripleCount + 1), (int)this.getTripleCount(oldSubGraph));
        SimpleGraphMaker sgm = (SimpleGraphMaker)((ModelMakerImpl)spec.getImportModelMaker()).getGraphMaker();
        ArrayList toGo = new ArrayList();
        Object i = sgm.listGraphs();
        while (i.hasNext()) {
            toGo.add(i.next());
        }
        i = toGo.iterator();
        while (i.hasNext()) {
            sgm.removeGraph((String)i.next());
        }
        dm.clearCache();
        OntModel newOntModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        newOntModel.read("http://protege.stanford.edu/plugins/owl/testdata/Import-normalizerBug.owl", "RDF/XML-ABBREV");
        Graph newSubGraph = (Graph)newOntModel.getSubGraphs().iterator().next();
        TestBugReports.assertFalse((newOntModel == oldOntModel ? (byte)1 : 0) != 0);
        TestBugReports.assertFalse((newSubGraph == oldSubGraph ? (byte)1 : 0) != 0);
        int newTripleCount = this.getTripleCount(newSubGraph);
        TestBugReports.assertEquals((int)oldTripleCount, (int)newTripleCount);
    }

    private int getTripleCount(Graph graph) {
        int count = 0;
        ExtendedIterator it = graph.find(null, null, null);
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public void test_fc_01() {
        OntModel m = ModelFactory.createOntologyModel();
        ObjectProperty p = m.createObjectProperty(NS + "p");
        Restriction r = m.createRestriction((Property)p);
        HasValueRestriction hv = r.convertToHasValueRestriction((RDFNode)m.createTypedLiteral(1));
        RDFNode n = hv.getHasValue();
        TestBugReports.assertFalse((String)"Should not be able to convert literal to individual", (boolean)n.canAs(Individual.class));
    }

    public void test_ck_01() {
        MockTransactionHandler m_t = new MockTransactionHandler();
        Graph g = Factory.createGraphMemWithTransactionHandler((TransactionHandler)m_t);
        Model m0 = ModelFactory.createModelForGraph((Graph)g);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM, (Model)m0);
        TestBugReports.assertFalse((String)"should not initially be in a transaction", (boolean)m_t.m_inTransaction);
        m1.begin();
        TestBugReports.assertTrue((String)"should be in a transaction", (boolean)m_t.m_inTransaction);
        m1.abort();
        TestBugReports.assertFalse((String)"should not still be in transaction", (boolean)m_t.m_inTransaction);
        TestBugReports.assertTrue((String)"transaction should have been aborted", (boolean)m_t.m_aborted);
        m1.begin();
        TestBugReports.assertTrue((String)"should be in a (new) transaction", (boolean)m_t.m_inTransaction);
        m1.commit();
        TestBugReports.assertFalse((String)"should not be in transaction post-commit", (boolean)m_t.m_inTransaction);
        TestBugReports.assertTrue((String)"should be marked committed post-commit", (boolean)m_t.m_committed);
    }

    public void test_ck_02() {
        OntModel vocabModel = ModelFactory.createOntologyModel();
        ObjectProperty p = vocabModel.createObjectProperty("p");
        OntClass A = vocabModel.createClass("A");
        OntModel workModel = ModelFactory.createOntologyModel();
        Individual sub = workModel.createIndividual("uri1", (Resource)A);
        Individual obj = workModel.createIndividual("uri2", (Resource)A);
        workModel.createStatement((Resource)sub, (Property)p, (RDFNode)obj);
    }

    public void test_ck_03() {
        OntModel model1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM, null);
        OntModel model2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RULE_INF, null);
        Individual sub = model1.createIndividual("http://mytest#i1", model1.getProfile().CLASS());
        OntProperty pred = model1.createOntProperty("http://mytest#");
        Individual obj = model1.createIndividual("http://mytest#i2", model1.getProfile().CLASS());
        OntProperty probabilityP = model1.createOntProperty("http://mytest#prob");
        Statement st = model1.createStatement((Resource)sub, (Property)pred, (RDFNode)obj);
        model1.add(st);
        st.createReifiedStatement().addLiteral((Property)probabilityP, 0.9);
        TestBugReports.assertTrue((String)"st should be reified", (boolean)st.isReified());
        Statement st2 = model2.createStatement((Resource)sub, (Property)pred, (RDFNode)obj);
        model2.add(st2);
        st2.createReifiedStatement().addLiteral((Property)probabilityP, 0.3);
        TestBugReports.assertTrue((String)"st2 should be reified", (boolean)st2.isReified());
        sub.addLiteral((Property)probabilityP, 0.3);
        sub.removeAll((Property)probabilityP).addLiteral((Property)probabilityP, 0.3);
        Individual sub2 = model2.createIndividual("http://mytest#i1", model1.getProfile().CLASS());
        sub.addLiteral((Property)probabilityP, 0.3);
        sub.removeAll((Property)probabilityP);
        sub2.addLiteral((Property)probabilityP, 0.3);
        sub2.removeAll((Property)probabilityP);
    }

    public void test_sjooseng_01() {
        String source = "<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#'    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >    <daml:Class rdf:about='http://localhost:8080/kc2c#C1'>        <daml:subClassOf>            <daml:Restriction>                <daml:onProperty rdf:resource='http://localhost:8080/kc2c#p1'/>                <daml:hasClass>                    <daml:Class>                        <daml:oneOf rdf:parseType=\"daml:collection\">                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i1'/>                            <daml:Thing rdf:about='http://localhost:8080/kc2c#i2'/>                        </daml:oneOf>                    </daml:Class>                </daml:hasClass>            </daml:Restriction>        </daml:subClassOf>    </daml:Class>    <daml:ObjectProperty rdf:about='http://localhost:8080/kc2c#p1'>        <rdfs:label>p1</rdfs:label>    </daml:ObjectProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((String)"http://www.daml.org/2001/03/daml+oil#");
        m.read((InputStream)new ByteArrayInputStream(source.getBytes()), "http://localhost:8080/kc2c");
        OntClass kc1 = m.getOntClass("http://localhost:8080/kc2c#C1");
        boolean found = false;
        ExtendedIterator it = kc1.listSuperClasses(false);
        while (it.hasNext()) {
            SomeValuesFromRestriction sr;
            OntClass sc;
            Restriction r;
            OntClass oc = (OntClass)it.next();
            if (!oc.isRestriction() || !(r = oc.asRestriction()).isSomeValuesFromRestriction() || !(sc = (OntClass)(sr = r.asSomeValuesFromRestriction()).getSomeValuesFrom()).isEnumeratedClass()) continue;
            EnumeratedClass ec = sc.asEnumeratedClass();
            TestBugReports.assertEquals((String)"Enumeration size should be 2", (int)2, (int)ec.getOneOf().size());
            found = true;
        }
        TestBugReports.assertTrue((boolean)found);
    }

    public void test_afs_01() {
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'   xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <owl:Class rdf:about='http://example.org/foo#A'>   </owl:Class></rdf:RDF>";
        String sourceA = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">    <rdf:Description rdf:about='http://example.org/foo#x'>    <rdf:type rdf:resource='http://example.org/foo#A' />   </rdf:Description></rdf:RDF>";
        Model tBox = ModelFactory.createDefaultModel();
        tBox.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        Model aBox = ModelFactory.createDefaultModel();
        aBox.read((InputStream)new ByteArrayInputStream(sourceA.getBytes()), "http://example.org/foo");
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        reasoner = reasoner.bindSchema(tBox);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM_RULE_INF);
        spec.setReasoner(reasoner);
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)aBox);
        ArrayList inds = new ArrayList();
        ExtendedIterator i = m.listIndividuals();
        while (i.hasNext()) {
            inds.add(i.next());
        }
        TestBugReports.assertTrue((String)"x should be an individual", (boolean)inds.contains(m.getResource("http://example.org/foo#x")));
    }

    public void test_to_01() {
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:daml='http://www.daml.org/2001/03/daml+oil#'>  <daml:Class rdf:about='http://example.org/foo#A'>    <daml:intersectionOf rdf:parseType=\"daml:collection\">       <daml:Class rdf:ID=\"B\" />       <daml:Class rdf:ID=\"C\" />    </daml:intersectionOf>  </daml:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM, null);
        m.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        OntClass A = m.getOntClass("http://example.org/foo#A");
        TestBugReports.assertNotNull((Object)A);
        IntersectionClass iA = A.asIntersectionClass();
        TestBugReports.assertNotNull((Object)iA);
        RDFList intersection = iA.getOperands();
        TestBugReports.assertNotNull((Object)intersection);
        TestBugReports.assertEquals((int)2, (int)intersection.size());
        TestBugReports.assertTrue((boolean)intersection.contains((RDFNode)m.getOntClass("http://example.org/foo#B")));
        TestBugReports.assertTrue((boolean)intersection.contains((RDFNode)m.getOntClass("http://example.org/foo#C")));
    }

    public void test_tl_01() {
        Resource r;
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl=\"http://www.w3.org/2002/07/owl#\">   <owl:SymmetricProperty rdf:about='http://example.org/foo#p1'>   </owl:SymmetricProperty>   <owl:TransitiveProperty rdf:about='http://example.org/foo#p2'>   </owl:TransitiveProperty>   <owl:InverseFunctionalProperty rdf:about='http://example.org/foo#p3'>   </owl:InverseFunctionalProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        boolean foundP1 = false;
        boolean foundP2 = false;
        boolean foundP3 = false;
        ExtendedIterator i = m.listOntProperties();
        while (i.hasNext()) {
            r = (Resource)i.next();
            foundP1 = foundP1 || r.getURI().equals("http://example.org/foo#p1");
            foundP2 = foundP2 || r.getURI().equals("http://example.org/foo#p2");
            foundP3 = foundP3 || r.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)foundP1);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)foundP2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)foundP3);
        foundP1 = false;
        foundP2 = false;
        foundP3 = false;
        i = m.listObjectProperties();
        while (i.hasNext()) {
            r = (Resource)i.next();
            foundP1 = foundP1 || r.getURI().equals("http://example.org/foo#p1");
            foundP2 = foundP2 || r.getURI().equals("http://example.org/foo#p2");
            foundP3 = foundP3 || r.getURI().equals("http://example.org/foo#p3");
        }
        TestBugReports.assertTrue((String)"p1 not listed", (boolean)foundP1);
        TestBugReports.assertTrue((String)"p2 not listed", (boolean)foundP2);
        TestBugReports.assertTrue((String)"p3 not listed", (boolean)foundP3);
    }

    public void test_der_01() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_TRANS_INF, null);
        Resource a = m.createResource("http://example.org#A");
        Resource b = m.createResource("http://example.org#B");
        OntClassImpl A = new OntClassImpl(a.asNode(), (EnhGraph)m){

            protected boolean hasSuperClassDirect(Resource cls) {
                throw new RuntimeException("did not find direct reasoner");
            }
        };
        A.hasSuperClass(b, true);
    }

    public void test_if_01() {
        OntModel m = ModelFactory.createOntologyModel();
        m.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/wine", "file:testing/ontology/bugs/oldwine.owl");
        m.getDocumentManager().addAltEntry("http://www.w3.org/2001/sw/WebOnt/guide-src/food", "file:testing/ontology/bugs/oldfood.owl");
        m.getDocumentManager().setProcessImports(false);
        m.read("http://www.w3.org/2001/sw/WebOnt/guide-src/wine");
        m.getDocumentManager().setProcessImports(true);
        m.getDocumentManager().loadImport(m, "http://www.w3.org/2001/sw/WebOnt/guide-src/food");
        OntClass ontclass = m.getOntClass("http://www.w3.org/2001/sw/WebOnt/guide-src/wine#Wine");
        int nNamed = 0;
        int nRestriction = 0;
        int nAnon = 0;
        ExtendedIterator iter2 = ontclass.listSuperClasses(true);
        while (iter2.hasNext()) {
            OntClass ontsuperclass = (OntClass)iter2.next();
            if (!ontsuperclass.isAnon()) {
                ++nNamed;
                continue;
            }
            if (ontsuperclass.canAs(Restriction.class)) {
                ontsuperclass.asRestriction();
                ++nRestriction;
                continue;
            }
            ++nAnon;
        }
        TestBugReports.assertEquals((String)"Should be two named super classes ", (int)2, (int)nNamed);
        TestBugReports.assertEquals((String)"Should be nine named super classes ", (int)9, (int)nRestriction);
        TestBugReports.assertEquals((String)"Should be no named super classes ", (int)0, (int)nAnon);
    }

    public void test_lt_01() {
        OntModel m = ModelFactory.createOntologyModel();
        DatatypeProperty p = m.createDatatypeProperty(NS + "p");
        OntClass c = m.createClass(NS + "A");
        Individual i = m.createIndividual(NS + "i", (Resource)c);
        i.addProperty((Property)p, "testData");
        int count = 0;
        NodeIterator j = i.listPropertyValues((Property)p);
        while (j.hasNext()) {
            j.next();
            ++count;
        }
        TestBugReports.assertEquals((String)"i should have one property", (int)1, (int)count);
    }

    public void test_dk_01() {
        OntModel m = ModelFactory.createOntologyModel();
        m.read("file:testing/ontology/bugs/test_dk_01.xml");
        String ns = "http://localhost:8080/Repository/QueryAgent/UserOntology/qgen-example-1#";
        String[] classes = new String[]{ns + "C1", ns + "C3", ns + "C2"};
        for (int i = 0; i < classes.length; ++i) {
            OntClass c = m.getOntClass(classes[i]);
            ExtendedIterator j = c.listDeclaredProperties();
            while (j.hasNext()) {
                j.next();
            }
        }
    }

    public void test_anon_0() {
        String ns = "http://example.org/foo#";
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'>   <owl:ObjectProperty rdf:about='http://example.org/foo#p' />   <owl:Class rdf:about='http://example.org/foo#A' />   <ex:A rdf:about='http://example.org/foo#x' />   <owl:Class rdf:about='http://example.org/foo#B'>     <owl:equivalentClass>      <owl:Restriction>        <owl:onProperty rdf:resource='http://example.org/foo#p' />        <owl:hasValue rdf:resource='http://example.org/foo#x' />      </owl:Restriction>     </owl:equivalentClass>   </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        m.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        OntClass B = m.getOntClass(ns + "B");
        Restriction r = B.getEquivalentClass().asRestriction();
        HasValueRestriction hvr = r.asHasValueRestriction();
        RDFNode n = hvr.getHasValue();
        TestBugReports.assertTrue((String)"Should be an individual", (boolean)(n instanceof Individual));
    }

    public void test_zj_0() {
        String ns = "file:/C:/orel/orel0_5.owl#";
        String sourceT = "<rdf:RDF     xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:ex='http://example.org/foo#'    xmlns:owl='http://www.w3.org/2002/07/owl#'      xmlns:orel='file:/C:/orel/orel0_5.owl#'      xml:base='file:/C:/orel/orel0_5.owl#'      xmlns='file:/C:/orel/orel0_5.owl#'> <owl:ObjectProperty rdf:ID='hasAgent' /> <owl:ObjectProperty rdf:ID='hasResource' /> <owl:Class rdf:ID='MyPlay'>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasResource'/>        <owl:hasValue>          <orel:Resource rdf:ID='myResource'>            <orel:resourceURI>http://mp3.com/newcd/sample.mp3</orel:resourceURI>          </orel:Resource>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='http://www.w3.org/2002/07/owl#Thing'/>    <rdfs:subClassOf>      <owl:Restriction>        <owl:onProperty rdf:resource='file:/C:/orel/orel0_5.owl#hasAgent'/>        <owl:hasValue>          <orel:Agent rdf:ID='myAgent'>            <orel:agentPK>123456789</orel:agentPK>          </orel:Agent>        </owl:hasValue>      </owl:Restriction>    </rdfs:subClassOf>    <rdfs:subClassOf rdf:resource='file:/C:/orel/orel0_5.owl#Play'/>  </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "file:/C:/orel/orel0_5.owl");
        OntClass myPlay = m.getOntClass(ns + "MyPlay");
        ExtendedIterator i = myPlay.listDeclaredProperties();
        while (i.hasNext()) {
            i.next();
        }
    }

    public void test_hc_01() throws Exception {
        for (int i = 0; i < 5; ++i) {
            OntModel m = ModelFactory.createOntologyModel();
            FileInputStream ifs = new FileInputStream("testing/ontology/relativenames.rdf");
            m.read((InputStream)ifs, "http://example.org/foo");
            ifs.close();
            m.close();
        }
    }

    public void test_sb_01() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF, null);
        OntResource result = null;
        Resource nullValueForResourceType = null;
        result = model.createOntResource(OntResource.class, nullValueForResourceType, "http://www.somewhere.com/models#SomeResourceName");
        TestBugReports.assertNotNull((Object)result);
    }

    public void test_der_02() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='hasPublications'>    <rdfs:domain>      <owl:Class>        <owl:unionOf rdf:parseType='Collection'>          <owl:Class rdf:about='#Project'/>          <owl:Class rdf:about='#Task'/>        </owl:unionOf>      </owl:Class>    </rdfs:domain>    <rdfs:domain rdf:resource='#Dummy' />    <rdfs:range rdf:resource='#Publications'/>  </owl:ObjectProperty>  <owl:Class rdf:ID='Dummy'>  </owl:Class></rdf:RDF>";
        String ns = "http://jena.hpl.hp.com/test#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF, null);
        m.read((InputStream)new ByteArrayInputStream(SOURCE.getBytes()), ns);
    }

    public void test_der_03() {
        String ns = "http://jena.hpl.hp.com/test#";
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass A = om.createClass(ns + "A");
        OntClass B = om.createClass(ns + "B");
        OntClass C = om.createClass(ns + "C");
        A.addSuperClass((Resource)B);
        A.addSuperClass((Resource)C);
        B.addSuperClass((Resource)C);
        C.addSuperClass((Resource)B);
        TestUtil.assertIteratorValues(this, A.listSuperClasses(true), new Object[]{B, C});
    }

    public void test_pd_01() {
        String SOURCE = "<?xml version='1.0'?><rdf:RDF    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'    xmlns:owl='http://www.w3.org/2002/07/owl#'    xml:base='http://iasi.cnr.it/leks/localSchema1#'    xmlns:test='http://iasi.cnr.it/test/test1#'    xmlns='http://iasi.cnr.it/test/test1#'>    <owl:Ontology rdf:about=''/>    <owl:Class rdf:ID='Hotel'/>    <owl:Class rdf:ID='Hotel5Stars'>        <rdfs:subClassOf>            <owl:Restriction>                <owl:onProperty rdf:resource='#hasCategory'/>                <owl:hasValue rdf:resource='#Category5'/>            </owl:Restriction>        </rdfs:subClassOf>    </owl:Class>    <owl:DatatypeProperty rdf:ID='hasCategory'>        <rdfs:range rdf:resource='http://www.w3.org/2001/XMLSchema#string'/>        <rdfs:domain rdf:resource='#Hotel'/>        <rdf:type rdf:resource='http://www.w3.org/2002/07/owl#FunctionalProperty'/>    </owl:DatatypeProperty>    <owl:Thing rdf:ID='Category5'/></rdf:RDF>";
        String ns = "http://iasi.cnr.it/leks/localSchema1#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, null);
        m.read((InputStream)new ByteArrayInputStream(SOURCE.getBytes()), ns);
        ExtendedIterator j = m.listRestrictions();
        while (j.hasNext()) {
            Restriction r = (Restriction)j.next();
            if (!r.isHasValueRestriction()) continue;
            HasValueRestriction hv = r.asHasValueRestriction();
            hv.getHasValue().toString();
        }
    }

    public void xxtest_oh_01() {
        String ns = "http://www.idi.ntnu.no/~herje/ja/";
        Resource[] expected = new Resource[]{ResourceFactory.createResource((String)(ns + "reiseliv.owl#Reiseliv")), ResourceFactory.createResource((String)(ns + "hotell.owl#Hotell")), ResourceFactory.createResource((String)(ns + "restaurant.owl#Restaurant")), ResourceFactory.createResource((String)(ns + "restaurant.owl#UteRestaurant")), ResourceFactory.createResource((String)(ns + "restaurant.owl#UteBadRestaurant")), ResourceFactory.createResource((String)(ns + "restaurant.owl#UteDoRestaurant")), ResourceFactory.createResource((String)(ns + "restaurant.owl#SkogRestaurant"))};
        this.test_oh_01scan(OntModelSpec.OWL_MEM, "No inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MINI_RULE_INF, "Mini rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_RULE_INF, "Full rule inf", expected);
        this.test_oh_01scan(OntModelSpec.OWL_MEM_MICRO_RULE_INF, "Micro rule inf", expected);
    }

    private void test_oh_01scan(OntModelSpec s, String prompt, Resource[] expected) {
        String ns = "http://www.idi.ntnu.no/~herje/ja/reiseliv.owl#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)s, null);
        m.read("file:testing/ontology/bugs/test_oh_01.owl");
        System.out.println(prompt);
        OntClass r = m.getOntClass(ns + "Reiseliv");
        ArrayList<OntClass> q = new ArrayList<OntClass>();
        HashSet<OntClass> seen = new HashSet<OntClass>();
        q.add(r);
        while (!q.isEmpty()) {
            OntClass c = (OntClass)q.remove(0);
            seen.add(c);
            ExtendedIterator i = c.listSubClasses(true);
            while (i.hasNext()) {
                OntClass ontClass = (OntClass)i.next();
                if (seen.contains(ontClass)) continue;
                q.add(ontClass);
            }
            System.out.println("  Seen class " + c);
        }
        int mask = (1 << expected.length) - 1;
        for (int j = 0; j < expected.length; ++j) {
            if (seen.contains(expected[j])) {
                mask &= ~(1 << j);
                continue;
            }
            System.out.println("Expected but did not see " + expected[j]);
        }
        for (Resource resource : seen) {
            boolean isExpected = false;
            for (int j = 0; !isExpected && j < expected.length; ++j) {
                isExpected = expected[j].equals(resource);
            }
            if (isExpected) continue;
            System.out.println("Got unexpected result " + resource);
        }
        TestBugReports.assertEquals((String)"Some expected results were not seen", (int)0, (int)mask);
    }

    public void test_sf_927641() {
        String ns = "http://example.org/test#";
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass c0 = m0.createClass(ns + "C0");
        OntClass c1 = m0.createClass(ns + "C1");
        OntClass c2 = m0.createClass(ns + "C2");
        OntClass c3 = m0.createClass(ns + "C3");
        c0.addSubClass((Resource)c1);
        c1.addSubClass((Resource)c2);
        c2.addEquivalentClass((Resource)c3);
        TestBugReports.assertFalse((String)"pass 1: c0 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c0, true));
        TestBugReports.assertFalse((String)"pass 1: c3 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c3, true));
        TestBugReports.assertFalse((String)"pass 1: c2 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c2, true));
        TestBugReports.assertTrue((String)"pass 1: c1 should be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c1, true));
        m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF);
        c0 = m0.createClass(ns + "C0");
        c1 = m0.createClass(ns + "C1");
        c2 = m0.createClass(ns + "C2");
        c3 = m0.createClass(ns + "C3");
        c0.addSubClass((Resource)c1);
        c1.addSubClass((Resource)c2);
        c2.addEquivalentClass((Resource)c3);
        TestBugReports.assertFalse((String)"pass 2: c0 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c0, true));
        TestBugReports.assertFalse((String)"pass 2: c3 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c3, true));
        TestBugReports.assertFalse((String)"pass 2: c2 should not be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c2, true));
        TestBugReports.assertTrue((String)"pass 2: c1 should be a direct super of c2", (boolean)c2.hasSuperClass((Resource)c1, true));
    }

    public void test_sf_934528() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource r = OWL.Thing.inModel((Model)m);
        OntClass thingClass = (OntClass)r.as(OntClass.class);
        TestBugReports.assertNotNull((Object)thingClass);
        r = OWL.Nothing.inModel((Model)m);
        OntClass nothingClass = (OntClass)r.as(OntClass.class);
        TestBugReports.assertNotNull((Object)nothingClass);
        OntClass c = m.getOntClass(OWL.Thing.getURI());
        TestBugReports.assertNotNull((Object)c);
        TestBugReports.assertEquals((Object)c, (Object)OWL.Thing);
        c = m.getOntClass(OWL.Nothing.getURI());
        TestBugReports.assertNotNull((Object)c);
        TestBugReports.assertEquals((Object)c, (Object)OWL.Nothing);
    }

    public void test_sf_940570() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass C = m.createClass(NS + "C");
        Resource a = m.createResource(NS + "a", (Resource)C);
        TestUtil.assertIteratorValues(this, m.listIndividuals(), new Object[]{a});
        OntModel dm = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RULE_INF);
        OntClass D = dm.createClass(NS + "D");
        Resource b = dm.createResource(NS + "b", (Resource)D);
        TestUtil.assertIteratorValues(this, dm.listIndividuals(), new Object[]{b});
    }

    public void test_sf_940570_rdfs() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass C = m.createClass(NS + "C");
        Resource a = m.createResource(NS + "a", (Resource)C);
        TestUtil.assertIteratorValues(this, m.listIndividuals(), new Object[]{a});
    }

    public void test_sf_940570_daml() {
        OntModel dm = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM_RULE_INF);
        OntClass D = dm.createClass(NS + "D");
        Resource b = dm.createResource(NS + "b", (Resource)D);
        TestUtil.assertIteratorValues(this, dm.listIndividuals(), new Object[]{b});
    }

    public void test_sf_945436() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <C rdf:ID='x'>    <rdfs:label xml:lang=''>a_label</rdfs:label>  </C>  <owl:Class rdf:ID='C'>  </owl:Class></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.read((Reader)new StringReader(SOURCE), null);
        Individual x = m.getIndividual("http://jena.hpl.hp.com/test#x");
        TestBugReports.assertEquals((String)"Label on resource x", (String)"a_label", (String)x.getLabel(null));
        TestBugReports.assertEquals((String)"Label on resource x", (String)"a_label", (String)x.getLabel(""));
        TestBugReports.assertSame((String)"fr label on resource x", null, (Object)x.getLabel("fr"));
    }

    public void test_sf_948995() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        DatatypeProperty dp = m.createDatatypeProperty(NS + "dp");
        dp.addRDFType(OWL.InverseFunctionalProperty);
        boolean ex = false;
        try {
            dp.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException e) {
            ex = true;
        }
        TestBugReports.assertTrue((String)"Should have been a conversion exception", (boolean)ex);
        m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        dp = m.createDatatypeProperty(NS + "dp");
        dp.addRDFType(OWL.InverseFunctionalProperty);
        ex = false;
        try {
            dp.as(InverseFunctionalProperty.class);
        }
        catch (ConversionException e) {
            ex = true;
        }
        TestBugReports.assertFalse((String)"Should not have been a conversion exception", (boolean)ex);
    }

    public void test_sf_969475() {
        String SOURCE = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>  <owl:ObjectProperty rdf:ID='p0'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q0' />    </owl:inverseOf>  </owl:ObjectProperty>  <owl:ObjectProperty rdf:ID='p1'>    <owl:inverseOf>      <owl:ObjectProperty rdf:ID='q1' />    </owl:inverseOf>  </owl:ObjectProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.read((Reader)new StringReader(SOURCE), null);
        ObjectProperty p0 = m.getObjectProperty("http://jena.hpl.hp.com/test#p0");
        OntProperty invP0 = p0.getInverseOf();
        TestBugReports.assertEquals((Object)m.getResource("http://jena.hpl.hp.com/test#q0"), (Object)invP0);
        TestBugReports.assertTrue((String)"Should be an ObjectProperty facet", (boolean)(invP0 instanceof ObjectProperty));
        ObjectProperty q1 = m.getObjectProperty("http://jena.hpl.hp.com/test#q1");
        OntProperty invQ1 = q1.getInverse();
        TestBugReports.assertEquals((Object)m.getResource("http://jena.hpl.hp.com/test#p1"), (Object)invQ1);
        TestBugReports.assertTrue((String)"Should be an ObjectProperty facet", (boolean)(invQ1 instanceof ObjectProperty));
    }

    public void test_sf_978259() {
        OntModel md = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntModel ml = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM);
        DataRange drd = md.createDataRange(md.createList((RDFNode[])new Resource[]{OWL.Thing}));
        TestBugReports.assertNotNull((Object)drd);
        HasValueRestriction hvrd = md.createHasValueRestriction(null, RDFS.seeAlso, (RDFNode)OWL.Thing);
        TestBugReports.assertNotNull((Object)hvrd);
        boolean ex = false;
        try {
            drd = ml.createDataRange(md.createList((RDFNode[])new Resource[]{OWL.Thing}));
        }
        catch (ProfileException e) {
            ex = true;
        }
        TestBugReports.assertTrue((boolean)ex);
        ex = false;
        try {
            hvrd = ml.createHasValueRestriction(null, RDFS.seeAlso, (RDFNode)OWL.Thing);
        }
        catch (ProfileException e) {
            ex = true;
        }
        TestBugReports.assertTrue((boolean)ex);
    }

    public void test_jb_01() {
        Model schema = ModelFactory.createDefaultModel();
        Model data = ModelFactory.createDefaultModel();
        Resource c = schema.createResource("http://example.com/foo#AClass");
        Resource i = data.createResource("http://example.com/foo#anInd");
        schema.add(c, RDF.type, (RDFNode)OWL.Class);
        data.add(i, RDF.type, (RDFNode)c);
        OntModel composite = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)schema);
        composite.addSubModel(data);
        Set s = composite.listIndividuals().toSet();
        TestBugReports.assertEquals((String)"should be one individual", (int)1, (int)s.size());
        TestBugReports.assertTrue((boolean)s.contains(i));
    }

    public void test_dab_01() {
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass c0 = m0.createClass(NS + "c0");
        ObjectProperty p0 = m0.createObjectProperty(NS + "p0");
        p0.setDomain((Resource)c0);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass c1 = m1.createClass(NS + "c1");
        c1.addSuperClass((Resource)c0);
        m1.addSubModel((Model)m0);
        OntClass cc0 = m1.getOntClass(NS + "c0");
        TestBugReports.assertNotNull((Object)cc0);
        TestUtil.assertIteratorValues(this, c1.listDeclaredProperties(), new Object[]{p0});
        TestUtil.assertIteratorValues(this, c0.listDeclaredProperties(false), new Object[]{p0});
        TestUtil.assertIteratorValues(this, cc0.listDeclaredProperties(false), new Object[]{p0});
    }

    public void test_dab_02a() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:unionOf   rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        a0.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listUnionClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        a1.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listUnionClasses();
        while (i2.hasNext()) {
            i2.next();
        }
    }

    public void test_dab_02b() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:intersectionOf   rdf:resource='http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        a0.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listIntersectionClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        a1.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listIntersectionClasses();
        while (i2.hasNext()) {
            i2.next();
        }
        OntModel a2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM);
        a2.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i3 = a2.listIntersectionClasses();
        while (i3.hasNext()) {
            i3.next();
        }
    }

    public void test_dab_02c() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'><rdf:Description>  <owl:complementOf   rdf:resource='http://www.w3.org/2002/07/owl#Nothing'/> </rdf:Description></rdf:RDF>";
        OntModel a0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        a0.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i = a0.listComplementClasses();
        while (i.hasNext()) {
            i.next();
        }
        OntModel a1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        a1.read((Reader)new StringReader(SOURCEA), null);
        ExtendedIterator i2 = a1.listComplementClasses();
        while (i2.hasNext()) {
            i2.next();
        }
    }

    public void test_on_01() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM);
        Individual i = m.createIndividual(DAML_OIL.Thing);
        TestBugReports.assertTrue((boolean)i.isIndividual());
    }

    public void test_kers_01() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM);
        OntClass r = m.createClass(NS + "r");
        OntClass a = m.createClass(NS + "a");
        OntClass b = m.createClass(NS + "b");
        OntClass c = m.createClass(NS + "c");
        OntClass d = m.createClass(NS + "d");
        OntClass e = m.createClass(NS + "e");
        OntClass f = m.createClass(NS + "f");
        OntClass g = m.createClass(NS + "g");
        g.addSuperClass((Resource)c);
        f.addSuperClass((Resource)c);
        e.addSuperClass((Resource)b);
        d.addSuperClass((Resource)b);
        c.addSuperClass((Resource)a);
        b.addSuperClass((Resource)a);
        r.addSubClass((Resource)a);
        r.addSubClass((Resource)b);
        r.addSubClass((Resource)c);
        r.addSubClass((Resource)d);
        r.addSubClass((Resource)e);
        r.addSubClass((Resource)f);
        r.addSubClass((Resource)g);
        TestUtil.assertIteratorValues(this, r.listSubClasses(true), new Object[]{a});
    }

    public void test_kers_02() {
        OntModel A = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model B = ModelFactory.createDefaultModel();
        TestBugReports.assertTrue((boolean)(A.getGraph().queryHandler() instanceof SimpleQueryHandler));
        TestBugReports.assertTrue((boolean)(B.getGraph().queryHandler() instanceof GraphMemFasterQueryHandler));
        TestBugReports.assertTrue((boolean)(A.getBaseModel().getGraph().queryHandler() instanceof GraphMemFasterQueryHandler));
    }

    public void test_am_01() {
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
        m0.addSubModel((Model)m1);
        TestBugReports.assertTrue((boolean)m0.containsResource((RDFNode)c));
        m0.removeSubModel((Model)m1);
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
    }

    public void test_am_02() {
        OntDocumentManager.getInstance().setProcessImports(false);
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine", "file:testing/ontology/owl/Wine/wine.owl");
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        String namespace = "http://www.w3.org/TR/2003/CR-owl-guide-20030818/wine";
        String classURI = namespace + "#Wine";
        m1.read(namespace);
        OntClass c = m1.getOntClass(classURI);
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
        m0.addSubModel((Model)m1);
        TestBugReports.assertTrue((boolean)m0.containsResource((RDFNode)c));
        m0.removeSubModel((Model)m1);
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
    }

    public void test_am_03() {
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
        m0.addSubModel((Model)m1);
        TestBugReports.assertTrue((boolean)m0.containsResource((RDFNode)c));
        m0.removeSubModel((Model)m1);
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
    }

    public void test_am_04() {
        OntModel m0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RDFS_INF);
        OntClass c = m1.createClass(NS + "c");
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
        m0.addSubModel((Model)m1);
        TestBugReports.assertTrue((boolean)m0.containsResource((RDFNode)c));
        m0.removeSubModel((Model)m1);
        TestBugReports.assertFalse((boolean)m0.containsResource((RDFNode)c));
    }

    public void testHolgersPolyadicPrefixMappingBug() {
        String IMPORTED_NAMESPACE = "http://imported#";
        String LOCAL_NAMESPACE = "http://local#";
        Model importedModel = ModelFactory.createDefaultModel();
        importedModel.setNsPrefix("", "http://imported#");
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("", "http://local#");
        ontModel.addSubModel(importedModel);
        TestBugReports.assertNull((Object)ontModel.getNsURIPrefix("http://imported#"));
    }

    public void test_tina_01() {
        String rule = "(?x rdf:type rdfs:Class) -> (?x rdf:type owl:Class).";
        GenericRuleReasoner reasoner = new GenericRuleReasoner(Rule.parseRules((String)rule));
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner((Reasoner)reasoner);
        OntModel ml = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        ExtendedIterator it3 = ml.listHierarchyRootClasses();
        while (it3.hasNext()) {
            it3.next();
        }
    }

    public void test_mongolito_01() {
        String SOURCEA = "<rdf:RDF    xmlns:rdf          ='http://www.w3.org/1999/02/22-rdf-syntax-ns#'    xmlns:owl          ='http://www.w3.org/2002/07/owl#'    xml:base           ='http://example.com/a#'>  <owl:Ontology>          <owl:imports rdf:resource='http://example.com/b' />  </owl:Ontology></rdf:RDF>";
        OntDocumentManager.getInstance().addAltEntry("http://example.com/b", "file:testing/ontology/bugs/test_dk_01.xml");
        OntModel a0 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        a0.read((Reader)new StringReader(SOURCEA), null);
        long a0count = a0.size();
        OntDocumentManager.getInstance().getModel("http://example.com/b").close();
        OntModel a1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        a1.read((Reader)new StringReader(SOURCEA), null);
        TestBugReports.assertEquals((String)"Models should be same size", (long)a0count, (long)a1.size());
    }

    public void test_isindividual() {
        OntModel defModel = ModelFactory.createOntologyModel();
        OntClass c = defModel.createClass("http://example.com/test#A");
        Individual i = c.createIndividual();
        TestBugReports.assertTrue((String)"i should be an individual", (boolean)i.isIndividual());
    }

    public void test_getClassOwlLite() {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM);
        m.getOntClass("http://example.com/foo");
    }

    public void xxtestModelMakerOpen() {
        ModelMaker mm = ModelFactory.createMemModelMaker();
        Model m = mm.openModel("http://example.com/foo");
        TestBugReports.assertTrue((boolean)m.isEmpty());
        m.close();
        boolean closed = false;
        Model m0 = mm.openModel("http://example.com/foo");
        try {
            TestBugReports.assertTrue((boolean)m0.isEmpty());
        }
        catch (ClosedException unexpected) {
            closed = true;
        }
        TestBugReports.assertFalse((String)"ModelMaker.openModel returned a closed model", (boolean)closed);
    }

    public void testDefaultPrefixeOWL() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertFalse((boolean)"owl:".equals(m.expandPrefix("owl:")));
    }

    public void testDefaultPrefixeRDF() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertFalse((boolean)"rdf:".equals(m.expandPrefix("rdf:")));
    }

    public void testDefaultPrefixeRDFS() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertFalse((boolean)"rdfs:".equals(m.expandPrefix("rdfs:")));
    }

    public void testDefaultPrefixeXSD() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertFalse((boolean)"xsd:".equals(m.expandPrefix("xsd:")));
    }

    public void testDefaultPrefixeDAML() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertEquals((String)"daml:", (String)m.expandPrefix("daml:"));
    }

    public void testDefaultPrefixeDC() {
        OntModel m = ModelFactory.createOntologyModel();
        TestBugReports.assertEquals((String)"dc:", (String)m.expandPrefix("dc:"));
    }

    public void testReadConneg0() {
        final boolean[] acceptHeaderSet = new boolean[]{false};
        OntModelImpl m = new OntModelImpl(OntModelSpec.OWL_MEM){

            protected Model readDelegate(String url) {
                acceptHeaderSet[0] = true;
                return super.readDelegate(url);
            }

            public boolean ignoreFileURI(String url) {
                return false;
            }
        };
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
        m.read("file:testing/ontology/bugs/koala.owl");
        TestBugReports.assertTrue((boolean)acceptHeaderSet[0]);
    }

    public void testReadConneg1() {
        final boolean[] acceptHeaderSet = new boolean[]{false};
        OntModelImpl m = new OntModelImpl(OntModelSpec.OWL_MEM){

            protected Model readDelegate(String url) {
                acceptHeaderSet[0] = true;
                return super.readDelegate(url);
            }
        };
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
        m.read("file:testing/ontology/bugs/koala.owl");
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
    }

    public void testReadConneg2() {
        final boolean[] acceptHeaderSet = new boolean[]{false};
        OntModelImpl m = new OntModelImpl(OntModelSpec.OWL_MEM){

            protected Model readDelegate(String url, String lang) {
                acceptHeaderSet[0] = true;
                return super.readDelegate(url, lang);
            }

            public boolean ignoreFileURI(String url) {
                return false;
            }
        };
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
        m.read("file:testing/ontology/bugs/koala.owl", "RDF/XML");
        TestBugReports.assertTrue((boolean)acceptHeaderSet[0]);
    }

    public void testReadConneg3() {
        final boolean[] acceptHeaderSet = new boolean[]{false};
        OntModelImpl m = new OntModelImpl(OntModelSpec.OWL_MEM){

            protected Model readDelegate(String url, String lang) {
                acceptHeaderSet[0] = true;
                return super.readDelegate(url, lang);
            }

            public boolean ignoreFileURI(String url) {
                return false;
            }
        };
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
        m.read("file:testing/ontology/bugs/koala.owl", "http://foo.com", "RDF/XML");
        TestBugReports.assertFalse((boolean)acceptHeaderSet[0]);
    }

    public void testIsIndividual1() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass c1 = m.createClass(NS + "C1");
        ExtendedIterator it = m.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            TestBugReports.assertFalse((String)(ontClass.getLocalName() + "should not be an individual"), (boolean)ontClass.isIndividual());
        }
    }

    public void testIsIndividual2() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass c1 = m.createClass(NS + "C1");
        ExtendedIterator it = m.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            TestBugReports.assertFalse((String)(ontClass.getLocalName() + "should not be an individual"), (boolean)ontClass.isIndividual());
        }
    }

    public void testIsIndividual3() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass c1 = m.createClass(NS + "C1");
        m.add(OWL.Class, RDF.type, (RDFNode)OWL.Class);
        ExtendedIterator it = m.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            TestBugReports.assertFalse((String)(ontClass.getLocalName() + " should not be an individual"), (boolean)ontClass.isIndividual());
        }
    }

    public void testIsIndividual4() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass c1 = m.createClass(NS + "C1");
        m.add(OWL.Class, RDF.type, (RDFNode)RDFS.Class);
        ExtendedIterator it = m.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            TestBugReports.assertFalse((String)(ontClass.getLocalName() + " should not be an individual"), (boolean)ontClass.isIndividual());
        }
    }

    public void testIsIndividual5() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM);
        OntClass c1 = m.createClass(NS + "C1");
        m.add(RDFS.Class, RDF.type, (RDFNode)RDFS.Class);
        ExtendedIterator it = m.listClasses();
        while (it.hasNext()) {
            OntClass ontClass = (OntClass)it.next();
            TestBugReports.assertFalse((String)(ontClass.getLocalName() + " should not be an individual"), (boolean)ontClass.isIndividual());
        }
    }

    public void testIsIndividual6a() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass punned = m.createClass(NS + "C1");
        OntClass c2 = m.createClass(NS + "C2");
        m.add((Resource)punned, RDF.type, (RDFNode)c2);
        TestBugReports.assertFalse((String)"should not be an individual", (boolean)c2.isIndividual());
        TestBugReports.assertTrue((String)"should be an individual", (boolean)punned.isIndividual());
    }

    public void testIsIndividual6b() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_MICRO_RULE_INF);
        OntClass punned = m.createClass(NS + "C1");
        OntClass c2 = m.createClass(NS + "C2");
        m.add((Resource)punned, RDF.type, (RDFNode)c2);
        TestBugReports.assertFalse((String)"should not be an individual", (boolean)c2.isIndividual());
        TestBugReports.assertTrue((String)"should be an individual", (boolean)punned.isIndividual());
    }

    public void testDP0() {
        String NS = "http://jena.hpl.hp.com/example#";
        OntModelSpec mySpec = OntModelSpec.OWL_LITE_MEM_TRANS_INF;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)mySpec);
        OntClass book = model.createClass(NS + "Book");
        OntProperty title = model.createOntProperty(NS + "title");
        ObjectProperty publisher = model.createObjectProperty(NS + "publisher");
        DatatypeProperty price = model.createDatatypeProperty(NS + "price");
        Individual sc1 = model.createIndividual(NS + "Ant: The Definitive Guide", (Resource)book);
        model.setStrictMode(true);
        TestBugReports.assertFalse((String)(book + " should not be an individual"), (boolean)book.canAs(Individual.class));
        TestBugReports.assertFalse((String)(title + " should not be an individual"), (boolean)title.canAs(Individual.class));
        TestBugReports.assertFalse((String)(publisher + " should not be an individual"), (boolean)publisher.canAs(Individual.class));
        TestBugReports.assertFalse((String)(price + " should not be an individual"), (boolean)price.canAs(Individual.class));
    }

    public void testES0() {
        OntModel m = ModelFactory.createOntologyModel();
        OntProperty p = m.createOntProperty(NS + "p");
        List sp = p.listSuperProperties().toList();
        TestBugReports.assertFalse((String)"super-properties should not include reflexive case", (boolean)sp.contains(p));
    }

    private int getStatementCount(OntModel ontModel) {
        int count = 0;
        StmtIterator it = ontModel.listStatements();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    static class MockTransactionHandler
    extends SimpleTransactionHandler {
        boolean m_inTransaction = false;
        boolean m_aborted = false;
        boolean m_committed = false;

        MockTransactionHandler() {
        }

        public void begin() {
            this.m_inTransaction = true;
        }

        public void abort() {
            this.m_inTransaction = false;
            this.m_aborted = true;
        }

        public void commit() {
            this.m_inTransaction = false;
            this.m_committed = true;
        }
    }
}

