/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierTripleMap;
import com.hp.hpl.jena.graph.test.AbstractTestReifier;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.lang.reflect.Constructor;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestReifier
extends AbstractTestReifier {
    protected final Class<? extends Graph> graphClass;
    protected final ReificationStyle style;

    public TestReifier(String name) {
        super(name);
        this.graphClass = null;
        this.style = null;
    }

    public TestReifier(Class<? extends Graph> graphClass, String name, ReificationStyle style) {
        super(name);
        this.graphClass = graphClass;
        this.style = style;
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTest((Test)MetaTestGraph.suite(TestReifier.class, GraphMem.class));
        result.addTest((Test)MetaTestGraph.suite(TestReifier.class, GraphMemFaster.class));
        result.setName(TestReifier.class.getSimpleName());
        return result;
    }

    @Override
    public Graph getGraph() {
        return this.getGraph(this.style);
    }

    @Override
    public Graph getGraph(ReificationStyle style) {
        try {
            Constructor<?> cons = TestReifier.getConstructor(this.graphClass, new Class[]{ReificationStyle.class});
            if (cons != null) {
                return (Graph)cons.newInstance(style);
            }
            Constructor<?> cons2 = TestReifier.getConstructor(this.graphClass, new Class[]{((Object)((Object)this)).getClass(), ReificationStyle.class});
            if (cons2 != null) {
                return (Graph)cons2.newInstance(new Object[]{this, style});
            }
            throw new JenaException("no suitable graph constructor found for " + this.graphClass);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public void testExtendedConstructorExists() {
        GraphBase parent = new GraphBase(){

            public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
                return null;
            }
        };
        SimpleReifierTripleMap tm = new SimpleReifierTripleMap();
        SimpleReifierFragmentsMap fm = new SimpleReifierFragmentsMap();
        SimpleReifier sr = new SimpleReifier(parent, (ReifierTripleMap)tm, (ReifierFragmentsMap)fm, ReificationStyle.Minimal);
    }
}

