/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.mem.faster.GraphMemFaster;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGraphListener
extends MetaTestGraph {
    public TestGraphListener(String name) {
        super(name);
    }

    public TestGraphListener(Class<? extends Graph> graphClass, String name, ReificationStyle style) {
        super(graphClass, name, style);
    }

    public static TestSuite suite() {
        return MetaTestGraph.suite(TestGraphListener.class, GraphMemFaster.class);
    }

    @Override
    public Graph getGraph() {
        Graph g = Factory.createGraphMem();
        g.getEventManager().register((GraphListener)new CheckChanges("simple tracking", g));
        return g;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CheckChanges
    implements GraphListener {
        protected Graph copy;
        protected Graph original;
        final String desc;

        public CheckChanges(String description, Graph g) {
            this.original = g;
            this.desc = description;
            this.copy = TestGraphListener.super.getGraph();
        }

        protected void verify() {
            GraphTestBase.assertIsomorphic(this.desc + " has not been tracked correctly. [delegating,copy-from-listener]", this.original, this.copy);
        }

        public void notifyAddIterator(Graph g, Iterator<Triple> it) {
            while (it.hasNext()) {
                this.copy.add(it.next());
            }
            this.verify();
        }

        public void notifyAddTriple(Graph g, Triple t) {
            this.copy.add(t);
            this.verify();
        }

        public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
            while (it.hasNext()) {
                this.copy.delete(it.next());
            }
            this.verify();
        }

        public void notifyDeleteTriple(Graph g, Triple t) {
            this.copy.delete(t);
            this.verify();
        }

        public void notifyEvent(Graph source, Object value) {
            if (value instanceof GraphEvents) {
                if (GraphEvents.removeAll.equals(value)) {
                    this.notifyRemoveAll(source, Triple.ANY);
                } else {
                    GraphEvents event = (GraphEvents)value;
                    if ("remove".equals(event.getTitle())) {
                        this.notifyRemoveAll(source, (Triple)event.getContent());
                    }
                }
            }
            this.verify();
        }

        public void notifyRemoveAll(Graph source, Triple t) {
            SimpleBulkUpdateHandler.removeAll((Graph)this.copy, (Node)t.getSubject(), (Node)t.getPredicate(), (Node)t.getObject());
            this.verify();
        }

        public void notifyAddList(Graph g, List<Triple> triples) {
            this.notifyAddIterator(g, triples.iterator());
        }

        public void notifyDeleteArray(Graph g, Triple[] triples) {
            this.notifyDeleteIterator(g, Arrays.asList(triples).iterator());
        }

        public void notifyAddArray(Graph g, Triple[] triples) {
            this.notifyAddIterator(g, Arrays.asList(triples).iterator());
        }

        public void notifyAddGraph(Graph g, Graph added) {
            this.notifyAddIterator(g, (Iterator<Triple>)added.find((TripleMatch)Triple.ANY));
        }

        public void notifyDeleteGraph(Graph g, Graph removed) {
            this.notifyDeleteIterator(g, (Iterator<Triple>)removed.find((TripleMatch)Triple.ANY));
        }

        public void notifyDeleteList(Graph g, List<Triple> list) {
            this.notifyDeleteIterator(g, list.iterator());
        }
    }
}

