/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced.test;

import com.hp.hpl.jena.enhanced.AlreadyLinkedViewException;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.enhanced.PersonalityConfigException;
import com.hp.hpl.jena.enhanced.Polymorphic;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.enhanced.test.TestAllImpl;
import com.hp.hpl.jena.enhanced.test.TestModelImpl;
import com.hp.hpl.jena.enhanced.test.TestNode;
import com.hp.hpl.jena.enhanced.test.TestObject;
import com.hp.hpl.jena.enhanced.test.TestObjectImpl;
import com.hp.hpl.jena.enhanced.test.TestProperty;
import com.hp.hpl.jena.enhanced.test.TestPropertyImpl;
import com.hp.hpl.jena.enhanced.test.TestSubject;
import com.hp.hpl.jena.enhanced.test.TestSubjectImpl;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFVisitor;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.JenaException;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPackage
extends GraphTestBase {
    private static final Personality<RDFNode> split = new Personality();
    private static final Personality<RDFNode> combo = new Personality();
    private static final GraphPersonality bitOfBoth = new GraphPersonality();
    private static final GraphPersonality broken = new GraphPersonality();
    static final int S = 1;
    static final int P = 2;
    static final int O = 3;

    public TestPackage(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPackage.class);
    }

    public void testEquals() {
        EnhNode a = new EnhNode(NodeCreateUtils.create("eg:example"), null);
        TestPackage.assertEquals((Object)a, (Object)a);
    }

    private static <X extends RDFNode> void miniAsSupports(String title, TestNode n, Class<X> intf, boolean rslt) {
        TestPackage.assertTrue((String)(title + ":sanity"), (boolean)(n instanceof Polymorphic));
        TestNode as1 = (TestNode)((EnhNode)n).viewAs(intf);
        TestNode as2 = (TestNode)((EnhNode)n).viewAs(intf);
        TestPackage.assertTrue((String)(title + ":idempotency"), (as1 == as2 ? (byte)1 : 0) != 0);
        TestPackage.assertEquals((String)(title + ":support"), (boolean)rslt, (boolean)((EnhNode)as1).supports(intf));
    }

    private static void oneNodeAsSupports(String title, TestNode n, boolean[] rslts) {
        TestPackage.miniAsSupports(title + "/TestSubject", n, TestSubject.class, rslts[0]);
        TestPackage.miniAsSupports(title + "/TestProperty", n, TestProperty.class, rslts[1]);
        TestPackage.miniAsSupports(title + "/TestObject", n, TestObject.class, rslts[2]);
    }

    private static void manyNodeAsSupports(String title, TestNode[] n, boolean[][] rslts) {
        for (int i = 0; i < n.length; ++i) {
            TestPackage.oneNodeAsSupports(title + "[" + i + "]", n[i], rslts[i]);
        }
    }

    private static void basic(String title, Personality<RDFNode> p) {
        Graph g = Factory.createGraphMem();
        TestModelImpl model = new TestModelImpl(g, p);
        TestPackage.graphAdd(g, "x R y;");
        TestNode[] nodes = new TestNode[]{model.aSubject(), model.aProperty(), model.anObject()};
        TestPackage.manyNodeAsSupports(title + "(a)", nodes, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(g, "y R x;");
        TestPackage.manyNodeAsSupports(title + "(b)", nodes, new boolean[][]{{true, false, true}, {false, true, false}, {true, false, true}});
        g.delete(TestPackage.triple("x R y"));
        TestPackage.manyNodeAsSupports(title + "(c)", nodes, new boolean[][]{{false, false, true}, {false, true, false}, {true, false, false}});
    }

    private void canImplement(String title, TestNode n, int wh, boolean rslt) {
        try {
            switch (wh) {
                case 1: {
                    n.asSubject().aProperty();
                    break;
                }
                case 2: {
                    n.asProperty().anObject();
                    break;
                }
                case 3: {
                    n.asObject().aSubject();
                }
            }
            TestPackage.assertTrue((String)"IllegalStateException expected.", (boolean)rslt);
        }
        catch (IllegalStateException e) {
            TestPackage.assertFalse((String)"IllegalStateException at the wrong time.", (boolean)rslt);
        }
    }

    private void canImplement(String title, TestNode n, boolean[] rslts) {
        this.canImplement(title + "/TestSubject", n, 1, rslts[0]);
        this.canImplement(title + "/TestProperty", n, 2, rslts[1]);
        this.canImplement(title + "/TestObject", n, 3, rslts[2]);
    }

    private void canImplement(String title, TestNode[] n, boolean[][] rslts) {
        for (int i = 0; i < n.length; ++i) {
            this.canImplement(title + "[" + i + "]", n[i], rslts[i]);
        }
    }

    private void follow(String title, Personality<RDFNode> p) {
        Graph g = Factory.createGraphMem();
        TestModelImpl model = new TestModelImpl(g, p);
        TestPackage.graphAdd(g, "a b c;");
        TestNode[] nodes = new TestNode[]{model.aSubject(), model.aProperty(), model.anObject()};
        this.canImplement(title + "(a)", nodes, new boolean[][]{{true, false, false}, {false, true, false}, {false, false, true}});
        TestPackage.graphAdd(g, "b a c;");
        this.canImplement(title + "(b)", nodes, new boolean[][]{{true, true, false}, {true, true, false}, {false, false, true}});
        g.delete(TestPackage.triple("a b c"));
        this.canImplement(title + "(c)", nodes, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        this.canImplement(title + "(c)", new TestNode[]{nodes[1].asSubject().aProperty(), nodes[2].asObject().aSubject(), nodes[0].asProperty().anObject()}, new boolean[][]{{false, true, false}, {true, false, false}, {false, false, true}});
        TestPackage.assertTrue((String)"Model cache test", (nodes[0].asProperty().anObject() == nodes[2] ? (byte)1 : 0) != 0);
    }

    private void cache(String title, Personality<RDFNode> p) {
        Graph g = Factory.createGraphMem();
        TestModelImpl model = new TestModelImpl(g, p);
        TestPackage.graphAdd(g, "a b a;");
        TestPackage.assertTrue((String)"Caching is on", (model.aSubject().asObject() == model.anObject() ? (byte)1 : 0) != 0);
        model.getNodeCacheControl().setEnabled(false);
        TestPackage.assertFalse((String)"Caching is off", (model.aSubject() == model.anObject() ? (byte)1 : 0) != 0);
    }

    public static void testSplitBasic() {
        TestPackage.basic("Split: ", split);
    }

    public static void testComboBasic() {
        TestPackage.basic("Combo: ", combo);
    }

    public void testSplitFollow() {
        this.follow("Split: ", split);
    }

    public void testComboFollow() {
        this.follow("Combo: ", combo);
    }

    public void testSplitCache() {
        this.cache("Split: ", split);
    }

    public void testComboCache() {
        this.cache("Combo: ", combo);
    }

    public static void testBitOfBothBasic() {
        TestPackage.basic("bob: ", (Personality<RDFNode>)bitOfBoth);
    }

    public void testBitOfBothFollow() {
        this.follow("bob: ", (Personality<RDFNode>)bitOfBoth);
    }

    public void testBitOfBothCache() {
        this.cache("bob: ", (Personality<RDFNode>)bitOfBoth);
    }

    public static void testBitOfBothSurprise() {
        Graph g = Factory.createGraphMem();
        TestModelImpl model = new TestModelImpl(g, (Personality<RDFNode>)bitOfBoth);
        TestPackage.graphAdd(g, "a a a;");
        TestSubject testSubjectImpl = model.aSubject();
        TestPackage.assertTrue((String)"BitOfBoth makes subjects using TestSubjectImpl", (boolean)(testSubjectImpl instanceof TestSubjectImpl));
        TestProperty testAllImpl = testSubjectImpl.aProperty();
        TestPackage.assertTrue((String)"BitOfBoth makes properties using TestAllImpl", (boolean)(testAllImpl instanceof TestAllImpl));
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testAllImpl == testAllImpl.asSubject() ? (byte)1 : 0) != 0);
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubjectImpl != testAllImpl.asSubject() ? (byte)1 : 0) != 0);
        TestPackage.assertTrue((String)"turning a TestAllImpl into a TestSubject is a no-op", (testSubjectImpl.asSubject() != testSubjectImpl.asSubject().asProperty().asSubject() ? (byte)1 : 0) != 0);
    }

    public static void testBrokenBasic() {
        try {
            TestPackage.basic("Broken: ", (Personality<RDFNode>)broken);
            TestPackage.fail((String)"broken is a misconfigured personality, but it wasn't detected.");
        }
        catch (PersonalityConfigException personalityConfigException) {
            // empty catch block
        }
    }

    public void testSimple() {
        Graph g = Factory.createGraphMem();
        Personality ours = BuiltinPersonalities.model.copy().add(Example.class, Example.factory);
        EnhGraph eg = new EnhGraph(g, ours);
        Node n = Node.createURI((String)"spoo:bar");
        EnhNode eNode = new EnhNode(Node.createURI((String)"spoo:bar"), eg);
        EnhNode eBlank = new EnhNode(Node.createAnon(), eg);
        TestPackage.assertTrue((String)"URI node can be an Example", (boolean)eNode.supports(Example.class));
        TestPackage.assertFalse((String)"Blank node cannot be an Example", (boolean)eBlank.supports(Example.class));
    }

    public void testAlreadyLinkedViewException() {
        Graph g = Factory.createGraphMem();
        Personality ours = BuiltinPersonalities.model.copy().add(Example.class, Example.factory);
        EnhGraph eg = new EnhGraph(g, ours);
        Node n = NodeCreateUtils.create("spoo:bar");
        Example eNode = new Example(n, eg);
        Example multiplexed = new Example(n, eg);
        multiplexed.as(Property.class);
        eNode.viewAs(Example.class);
        try {
            eNode.addView((Polymorphic)multiplexed);
            TestPackage.fail((String)"should raise an AlreadyLinkedViewException ");
        }
        catch (AlreadyLinkedViewException e) {
            // empty catch block
        }
    }

    public void testNullPointerTrap() {
        EnhGraph eg = new EnhGraph(Factory.createGraphMem(), new Personality());
        Node n = NodeCreateUtils.create("eh:something");
        EnhNode en = new EnhNode(n, eg);
        try {
            en.as(Property.class);
            TestPackage.fail((String)"oops");
        }
        catch (UnsupportedPolymorphismException e) {
            TestPackage.assertEquals((Object)en, (Object)e.getBadNode());
            TestPackage.assertTrue((String)"exception should have cuplprit graph", (eg == e.getBadGraph() ? (byte)1 : 0) != 0);
            TestPackage.assertSame((String)"exception should have culprit class", Property.class, (Object)e.getBadClass());
        }
    }

    public void testNullPointerTrapInCanSupport() {
        EnhGraph eg = new EnhGraph(Factory.createGraphMem(), new Personality());
        Node n = NodeCreateUtils.create("eh:something");
        EnhNode en = new EnhNode(n, eg);
        TestPackage.assertFalse((boolean)en.canAs(Property.class));
    }

    public void testAsToOwnClassWithNoModel() {
        Resource r = ResourceFactory.createResource();
        TestPackage.assertEquals(null, (Object)r.getModel());
        TestPackage.assertTrue((boolean)r.canAs(Resource.class));
        TestPackage.assertSame((Object)r, (Object)r.as(Resource.class));
    }

    public void testCanAsReturnsFalseIfNoModel() {
        Resource r = ResourceFactory.createResource();
        TestPackage.assertEquals((boolean)false, (boolean)r.canAs(Example.class));
    }

    public void testAsThrowsPolymorphismExceptionIfNoModel() {
        Resource r = ResourceFactory.createResource();
        try {
            r.as(Example.class);
            TestPackage.fail((String)"should throw UnsupportedPolymorphismException");
        }
        catch (UnsupportedPolymorphismException e) {
            TestPackage.assertEquals(null, (Object)e.getBadGraph());
            TestPackage.assertEquals(Example.class, (Object)e.getBadClass());
        }
    }

    static {
        split.add(TestObject.class, TestObjectImpl.factory);
        split.add(TestSubject.class, TestSubjectImpl.factory);
        split.add(TestProperty.class, TestPropertyImpl.factory);
        combo.add(TestObject.class, TestAllImpl.factory);
        combo.add(TestSubject.class, TestAllImpl.factory);
        combo.add(TestProperty.class, TestAllImpl.factory);
        bitOfBoth.add(TestObject.class, TestObjectImpl.factory);
        bitOfBoth.add(TestSubject.class, TestSubjectImpl.factory);
        bitOfBoth.add(TestProperty.class, TestAllImpl.factory);
        broken.add(TestObject.class, TestObjectImpl.factory);
        broken.add(TestSubject.class, TestSubjectImpl.factory);
        broken.add(TestProperty.class, TestObjectImpl.factory);
    }

    static class AnotherExample {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node n, EnhGraph g) {
                return new EnhNode(n, g);
            }

            public boolean canWrap(Node n, EnhGraph g) {
                return n.isURI();
            }
        };

        AnotherExample() {
        }
    }

    static class Example
    extends EnhNode
    implements RDFNode {
        static final Implementation factory = new Implementation(){

            public EnhNode wrap(Node n, EnhGraph g) {
                return new EnhNode(n, g);
            }

            public boolean canWrap(Node n, EnhGraph g) {
                return n.isURI();
            }
        };

        public Example(Node n, EnhGraph g) {
            super(n, g);
        }

        public RDFNode inModel(Model m) {
            return null;
        }

        public Model getModel() {
            throw new JenaException("getModel() should not be called in the EnhGraph/Node tests");
        }

        public Resource asResource() {
            throw new JenaException("asResource() should not be called in the EnhGraph/Node tests");
        }

        public Literal asLiteral() {
            throw new JenaException("asLiteral() should not be called in the EnhGraph/Node tests");
        }

        public Object visitWith(RDFVisitor rv) {
            return null;
        }
    }
}

