/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConnection
extends TestCase {
    protected static Logger logger = LoggerFactory.getLogger(TestConnection.class);
    String DefModel = "DEFAULT";
    volatile String msg = "";

    public TestConnection(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestConnection.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestConnection.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        IDBConnection result = TestConnection.makeTestConnection();
        boolean tryClean = true;
        boolean didClean = false;
        boolean tryUnlock = true;
        String err = null;
        while (tryClean && !didClean) {
            try {
                result.cleanDB();
                didClean = true;
            }
            catch (Exception e) {
                err = err + "\n" + e;
                if (tryUnlock) {
                    tryUnlock = false;
                    if (!result.getDriver().DBisLocked()) continue;
                    try {
                        result.getDriver().unlockDB();
                    }
                    catch (Exception e1) {
                        err = err + "\n" + e1;
                    }
                    continue;
                }
                tryClean = false;
            }
        }
        if (!didClean) {
            throw new JenaException("Failed to clean database.\n" + err);
        }
        return result;
    }

    public void testRecovery() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = null;
        try {
            m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
            m.close();
        }
        catch (Exception e) {
            TestConnection.assertTrue((boolean)false);
        }
        try {
            m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.close();
    }

    public void testDBConnect() throws Exception {
        IDBConnection conn = TestConnection.makeTestConnection();
        conn.close();
    }

    public void testBadConnection() throws Exception {
        try {
            DBConnection conn = new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, "Bad DB");
            conn.cleanDB();
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConstructDefaultModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn);
        m.remove();
        conn.close();
    }

    public void testConstructAndOpenDefaultModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn);
        m.close();
        ModelRDB m2 = ModelRDB.open((IDBConnection)conn);
        m2.remove();
        conn.close();
    }

    public void testConstructNamedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.remove();
        conn.close();
    }

    public void testBadNamedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = null;
        try {
            m = ModelRDB.createModel((IDBConnection)conn, (String)this.DefModel);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.close();
    }

    public void testBadNamedFactoryModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelMaker maker = ModelFactory.createModelRDBMaker((IDBConnection)conn);
        Model m = null;
        try {
            m = maker.createModel(this.DefModel);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        conn.close();
    }

    public void testReconstructDefaultModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn);
        m.remove();
        ModelRDB m1 = ModelRDB.createModel((IDBConnection)conn);
        m1.remove();
        conn.close();
    }

    public void testReconstructNamedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.remove();
        ModelRDB m1 = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m1.remove();
        conn.close();
    }

    public void testConstructAndOpenNamedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.close();
        ModelRDB m2 = ModelRDB.open((IDBConnection)conn, (String)"myName");
        m2.remove();
        conn.close();
    }

    public void testConstructParamaterizedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
        m.remove();
        conn.close();
    }

    public void testConstructAndOpenParamaterizedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
        m.close();
        ModelRDB m2 = ModelRDB.open((IDBConnection)conn);
        m2.remove();
        conn.close();
    }

    public void testConstructNamedParamaterizedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName", (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
        m.remove();
        conn.close();
    }

    public void testConstructAndOpenNamedParamaterizedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName", (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
        m.close();
        ModelRDB m2 = ModelRDB.open((IDBConnection)conn, (String)"myName");
        m2.remove();
        conn.close();
    }

    public void testOpenNamedNonExistentModel() throws Exception {
        IDBConnection conn = TestConnection.makeTestConnection();
        try {
            ModelRDB m2 = ModelRDB.open((IDBConnection)conn, (String)"myName");
            m2.remove();
            conn.close();
            TestConnection.assertTrue((String)"Successfully opened non-existent model", (boolean)false);
        }
        catch (DoesNotExistException e) {
            conn.close();
        }
    }

    public void testOpenUnnamedNonExistentModel() throws Exception {
        IDBConnection conn = TestConnection.makeTestConnection();
        try {
            conn.cleanDB();
            ModelRDB m2 = ModelRDB.open((IDBConnection)conn);
            m2.remove();
            conn.close();
            TestConnection.assertTrue((String)"Successfully opened unnamed non-existent model", (boolean)false);
        }
        catch (DoesNotExistException e) {
            conn.close();
        }
    }

    public void testCreateExistingModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName", (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
        try {
            ModelRDB m2 = ModelRDB.createModel((IDBConnection)conn, (String)"myName", (Model)ModelRDB.getDefaultModelProperties((IDBConnection)conn));
            m.remove();
            m2.remove();
            conn.close();
            TestConnection.assertTrue((String)"Successfully created pre-existing model", (boolean)false);
        }
        catch (AlreadyExistsException e) {
            m.remove();
            conn.close();
        }
    }

    public void addToDBGraphProp(Model model, Property prop, String val) {
        StmtIterator iter = model.listStatements((Selector)new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestConnection.assertTrue((boolean)iter.hasNext());
        Statement stmt = iter.nextStatement();
        TestConnection.assertTrue((!iter.hasNext() ? (byte)1 : 0) != 0);
        Resource graphURI = stmt.getSubject();
        Literal l = model.createLiteral(val);
        Statement s = model.createStatement(graphURI, prop, (RDFNode)l);
        model.add(s);
        TestConnection.assertTrue((boolean)model.contains(s));
    }

    public void testConstructDefSchemaModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        conn.getDriver().setStoreWithModel("");
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn);
        m.remove();
        conn.close();
    }

    public void testConstructBadSchemaModel() throws Exception {
        ModelRDB m;
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        conn.getDriver().setStoreWithModel(this.DefModel);
        try {
            m = ModelRDB.createModel((IDBConnection)conn);
            m.remove();
            TestConnection.assertFalse((String)"Created model with non-existent schema", (boolean)true);
        }
        catch (RDFRDBException e) {
            // empty catch block
        }
        conn.getDriver().setStoreWithModel("MODEL_DOES_NOT_EXIST");
        try {
            m = ModelRDB.createModel((IDBConnection)conn);
            m.remove();
            TestConnection.assertFalse((String)"Created model with non-existent schema", (boolean)true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        conn.close();
    }

    public void testConstructNamedModelDefSchema() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        conn.getDriver().setStoreWithModel(null);
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.remove();
        conn.close();
    }

    public void testConstructNamedModelDefSchema1() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB mdef = ModelRDB.createModel((IDBConnection)conn);
        conn.getDriver().setStoreWithModel(this.DefModel);
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        mdef.remove();
        m.remove();
        conn.close();
    }

    public void testConstructNamedModelDefSchema2() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB mdef = ModelRDB.createModel((IDBConnection)conn);
        conn.getDriver().setStoreWithModel(null);
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        mdef.remove();
        m.remove();
        conn.close();
    }

    public void testConstructNamedModelSchema() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        ModelRDB m1 = ModelRDB.createModel((IDBConnection)conn, (String)"model1");
        conn.getDriver().setStoreWithModel("model1");
        ModelRDB m2 = ModelRDB.createModel((IDBConnection)conn, (String)"model2");
        m1.remove();
        m2.remove();
        conn.close();
    }

    public void testNamedPrefixedModel() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setTableNamePrefix("foo_");
        conn.cleanDB();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.remove();
        conn.cleanDB();
        conn.close();
    }

    public void testNamedPrefixedPersists() throws Exception {
        IDBConnection conn = TestConnection.makeTestConnection();
        IRDBDriver d = conn.getDriver();
        String pfx = "foo_";
        d.setTableNamePrefix(pfx);
        conn.cleanDB();
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn, (String)"myName");
        m.close();
        conn.close();
        conn = TestConnection.makeTestConnection();
        d = conn.getDriver();
        d.setTableNamePrefix(pfx);
        m = ModelRDB.open((IDBConnection)conn, (String)"myName");
        TestConnection.assertTrue((boolean)d.getTableNamePrefix().equalsIgnoreCase(pfx));
        conn.cleanDB();
    }

    public void testNamedPrefixFailure() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        String longPfx = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        try {
            d.setTableNamePrefix(longPfx);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        ModelRDB m = ModelRDB.createModel((IDBConnection)conn);
        try {
            d.setTableNamePrefix("foo_");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        m.close();
        conn.close();
    }

    public void testConcurrentThread() {
        if (!TestPackage.M_DBCONCURRENT) {
            logger.warn("Transaction isolation test surpressed");
            return;
        }
        SyncOnCount s = new SyncOnCount();
        class Thread1
        extends Thread {
            SyncOnCount s;

            public Thread1(SyncOnCount sc) {
                super("thread1");
                this.s = sc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Statement stmt;
                ModelRDB foo;
                block23: {
                    IDBConnection conn = TestConnection.makeAndCleanTestConnection();
                    foo = ModelRDB.createModel((IDBConnection)conn, (String)"foo");
                    this.s.incCount();
                    this.s.waitOnCount(2);
                    Resource u = foo.createResource("test#subject");
                    Property p = foo.createProperty("test#predicate");
                    Resource o = foo.createResource("test#object");
                    stmt = foo.createStatement(u, p, (RDFNode)o);
                    if (foo.contains(stmt)) {
                        String string = TestConnection.this.msg;
                        synchronized (string) {
                            if (TestConnection.this.msg.length() == 0) {
                                TestConnection.this.msg = "Thread 1 can see uncommited statement";
                            }
                            this.s.incCount(99);
                            return;
                        }
                    }
                    this.s.incCount();
                    this.s.waitOnCount(4);
                    if (!foo.contains(stmt)) {
                        String string = TestConnection.this.msg;
                        synchronized (string) {
                            if (TestConnection.this.msg.length() == 0) {
                                TestConnection.this.msg = "Thread 1 can't see commited statement";
                            }
                            this.s.incCount(99);
                            return;
                        }
                    }
                    break block23;
                    finally {
                        try {
                            conn.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                foo.remove(stmt);
                this.s.incCount();
            }
        }
        Thread1 t1 = new Thread1(s);
        class Thread2
        extends Thread {
            SyncOnCount s;

            public Thread2(SyncOnCount sc) {
                super("thread2");
                this.s = sc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block25: {
                    this.s.waitOnCount(1);
                    conn = TestConnection.makeTestConnection();
                    foo = ModelRDB.open((IDBConnection)conn, (String)"foo");
                    foo.begin();
                    u = foo.createResource("test#subject");
                    p = foo.createProperty("test#predicate");
                    o = foo.createResource("test#object");
                    stmt = foo.createStatement(u, p, (RDFNode)o);
                    foo.add(stmt);
                    this.s.incCount();
                    this.s.waitOnCount(3);
                    if (foo.contains(stmt)) break block25;
                    var7_8 = TestConnection.this.msg;
                    synchronized (var7_8) {
                        if (TestConnection.this.msg.length() == 0) {
                            TestConnection.this.msg = "Thread 2 can't see statement it just added";
                        }
                        this.s.incCount(99);
                    }
                    try {
                        conn.close();
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    foo.commit();
                }
                catch (Exception e) {
                    if (TestConnection.this.msg.length() == 0) {
                        TestConnection.this.msg = "Failed to commit transaction: " + e.getMessage();
                    }
                    try {
                        conn.close();
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                ** try [egrp 6[TRYBLOCK] [11 : 229->298)] { 
lbl45:
                // 1 sources

                this.s.incCount();
                this.s.waitOnCount(5);
                if (foo.contains(stmt) == false) return;
                var7_10 = TestConnection.this.msg;
                synchronized (var7_10) {
                    if (TestConnection.this.msg.length() == 0) {
                        TestConnection.this.msg = "Thread 2 can see statement thread 1 should have removed";
                    }
                    this.s.incCount(99);
                    return;
                }
lbl54:
                // 1 sources

                finally {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Thread2 t2 = new Thread2(s);
        t2.start();
        t1.start();
        try {
            t1.join();
            t2.join();
        }
        catch (Exception e) {
            TestConnection.assertTrue((boolean)false);
        }
        if (this.msg != null && this.msg.length() > 0) {
            TestConnection.assertTrue((String)this.msg, (boolean)false);
        }
    }

    public void testDBMutex() {
        ModelRDB foo;
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.lockDB();
        try {
            foo = ModelRDB.createModel((IDBConnection)conn, (String)"foo");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        d.unlockDB();
        if (d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (conn.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        foo = ModelRDB.createModel((IDBConnection)conn, (String)"foo");
        if (!d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (!conn.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (conn.containsModel("bar")) {
            TestConnection.assertTrue((boolean)false);
        }
        d.deleteTable(d.getSystemTableName(0));
        if (d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            TestConnection.assertTrue((boolean)false);
        }
        conn = TestConnection.makeTestConnection();
        d = conn.getDriver();
        if (conn.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        ModelRDB bar = ModelRDB.createModel((IDBConnection)conn, (String)"bar");
        if (!d.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (conn.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (!conn.containsModel("bar")) {
            TestConnection.assertTrue((boolean)false);
        }
        bar.begin();
        try {
            bar.remove();
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        bar.abort();
        bar.remove();
        try {
            conn.close();
        }
        catch (Exception e) {
            TestConnection.assertTrue((boolean)false);
        }
    }

    public class SyncOnCount {
        private int count = 0;

        public synchronized boolean testCount(int i) {
            return this.count >= i;
        }

        public void incCount() {
            this.incCount(1);
        }

        public synchronized void incCount(int N) {
            this.count += N;
        }

        public void waitOnCount(int cnt) {
            int i = 0;
            for (i = 0; i < 100; ++i) {
                try {
                    if (this.testCount(cnt)) break;
                    Thread.yield();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("waitOnCount interrupted" + e);
                }
            }
            if (!this.testCount(cnt)) {
                System.err.println();
                System.err.println("Expected=" + cnt + " Actual=" + this.count);
                Assert.assertTrue((String)"waitOnCount", (boolean)false);
            }
        }
    }
}

