/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.exceptions.TransactionAbortedException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.assembler.test.MockTransactionModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestModelContent
extends AssemblerTestBase {
    public TestModelContent(String name) {
        super(name);
    }

    @Override
    protected Class<? extends Assembler> getAssemblerClass() {
        return null;
    }

    public void testMemoryModelLoadsSingleContent() {
        this.testModelLoadsSingleContent(Assembler.memoryModel, JA.MemoryModel);
    }

    public void testMemoryModelLoadsMultipleContent() {
        this.testModelLoadsMultipleContent(Assembler.memoryModel, JA.MemoryModel);
    }

    public void testDefaultModelLoadsSingleContent() {
        this.testModelLoadsSingleContent(Assembler.defaultModel, JA.DefaultModel);
    }

    public void testDefaultModelLoadsMultipleContent() {
        this.testModelLoadsMultipleContent(Assembler.defaultModel, JA.DefaultModel);
    }

    public void testInfModelLoadsContent() {
        this.testModelLoadsMultipleContent(Assembler.infModel, JA.InfModel);
    }

    public void testContentTransactionsNone() {
        ArrayList<String> history = new ArrayList<String>();
        Model expected = this.model("_x rdf:value '17'xsd:integer");
        MockTransactionModel a = new MockTransactionModel(history, expected, false, true);
        Resource root = this.resourceInModel("x rdf:type ja:Model; x ja:content y; y rdf:type ja:Content; y rdf:type ja:LiteralContent; y ja:literalContent '_:x\\srdf:value\\s17\\s.'");
        try {
            a.open(Assembler.content, root);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testContentTransactionsCommit() {
        ArrayList<String> history = new ArrayList<String>();
        Model expected = this.model("_x rdf:value '17'xsd:integer");
        MockTransactionModel a = new MockTransactionModel(history, expected, true, false);
        Resource root = this.resourceInModel("x rdf:type ja:Model; x ja:content y; y rdf:type ja:Content; y rdf:type ja:LiteralContent; y ja:literalContent '_:x\\srdf:value\\s17\\s.'");
        Model m = (Model)a.open(Assembler.content, root);
        TestModelContent.assertEquals(TestModelContent.listOfStrings("supports[true] begin add commit"), history);
        TestModelContent.assertIsoModels(expected, m);
    }

    public void testContentTransactionsAbort() {
        ArrayList<String> history = new ArrayList<String>();
        Model expected = this.model("_x rdf:value '17'xsd:integer");
        Model toDeliver = this.model("").add(expected);
        MockTransactionModel a = new MockTransactionModel(history, toDeliver, true, true);
        try {
            Resource root = this.resourceInModel("x rdf:type ja:Model; x ja:content y; y rdf:type ja:Content; y rdf:type ja:LiteralContent; y ja:literalContent '_:x\\srdf:value\\s17\\s.'");
            a.open(Assembler.content, root);
            TestModelContent.fail((String)"should throw (wrapped) failing exception");
        }
        catch (TransactionAbortedException e) {
            TestModelContent.assertEquals((Object)TestModelContent.resource("x"), (Object)e.getRoot());
            TestModelContent.assertEquals(TestModelContent.listOfStrings("supports[true] begin add abort"), history);
            TestModelContent.assertIsoModels(expected, toDeliver);
        }
    }

    protected void testModelLoadsSingleContent(Assembler a, Resource type) {
        Resource root = this.resourceInModel("x rdf:type " + type + "; x ja:content y; y rdf:type ja:Content" + "; y rdf:type ja:LiteralContent; y ja:literalContent '_:x\\srdf:value\\s17\\s.'");
        Model m = (Model)a.open(Assembler.content, root);
        TestModelContent.assertIsoModels(this.model("_x rdf:value '17'xsd:integer"), m);
    }

    protected void testModelLoadsMultipleContent(Assembler a, Resource type) {
        Model m = (Model)a.open(Assembler.content, this.resourceInModel("x rdf:type " + type + "; x ja:content y; x ja:content z" + "; y rdf:type ja:Content; y rdf:type ja:LiteralContent; y ja:literalContent '_:x\\srdf:value\\s17\\s.'" + "; z rdf:type ja:Content; z rdf:type ja:LiteralContent; z ja:literalContent '_:x\\srdf:value\\s42\\s.'"));
        TestModelContent.assertIsoModels(this.model("_x rdf:value '17'xsd:integer; _y rdf:value '42'xsd:integer"), m);
    }
}

