/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.CannotConstructException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.LocationMappingVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssemblerTestBase
extends ModelTestBase {
    protected static final Model schema = JA.getSchema();

    protected Class<? extends Assembler> getAssemblerClass() {
        throw new BrokenException("this class must define getAssemblerClass");
    }

    public AssemblerTestBase(String name) {
        super(name);
    }

    protected Model model(String string) {
        Model result = AssemblerTestBase.createModel(ReificationStyle.Standard);
        this.setRequiredPrefixes(result);
        return this.modelAddFacts(result, string);
    }

    protected Model model() {
        return this.model("");
    }

    protected Model modelAddFacts(Model result, String string) {
        return AssemblerTestBase.modelAdd(result, string);
    }

    protected Model setRequiredPrefixes(Model m) {
        m.setNsPrefix("ja", JA.getURI());
        m.setNsPrefix("lm", LocationMappingVocab.getURI());
        return m;
    }

    protected Resource resourceInModel(String string) {
        Model m = this.model(string);
        Resource r = AssemblerTestBase.resource(m, string.substring(0, string.indexOf(32)));
        return r.inModel(m);
    }

    protected void testDemandsMinimalType(Assembler a, Resource type) {
        try {
            a.open(this.resourceInModel("x rdf:type rdf:Resource"));
            AssemblerTestBase.fail((String)"should trap insufficient type");
        }
        catch (CannotConstructException e) {
            AssemblerTestBase.assertEquals(this.getAssemblerClass(), (Object)e.getAssemblerClass());
            AssemblerTestBase.assertEquals((Object)type, (Object)e.getType());
            AssemblerTestBase.assertEquals((Object)AssemblerTestBase.resource("x"), (Object)e.getRoot());
        }
    }

    protected void assertSamePrefixMapping(PrefixMapping wanted, PrefixMapping got) {
        if (!wanted.samePrefixMappingAs(got)) {
            AssemblerTestBase.fail((String)("wanted: " + wanted + " but got: " + got));
        }
    }

    protected void assertDomain(Resource domain, Property p) {
        if (!schema.contains((Resource)p, RDFS.domain, (RDFNode)domain)) {
            AssemblerTestBase.fail((String)(p + " was expected to have domain " + domain));
        }
    }

    protected void assertRange(Resource range, Property p) {
        if (!schema.contains((Resource)p, RDFS.range, (RDFNode)range)) {
            AssemblerTestBase.fail((String)(p + " was expected to have range " + range));
        }
    }

    protected void assertSubclassOf(Resource expectedSub, Resource expectedSuper) {
        if (!schema.contains(expectedSub, RDFS.subClassOf, (RDFNode)expectedSuper)) {
            AssemblerTestBase.fail((String)(expectedSub + " should be a subclass of " + expectedSuper));
        }
    }

    protected void assertType(Resource type, Resource instance) {
        if (!schema.contains(instance, RDF.type, (RDFNode)type)) {
            AssemblerTestBase.fail((String)(instance + " should have rdf:type " + type));
        }
    }

    protected static class NamedObjectAssembler
    extends AssemblerBase {
        final Resource name;
        final Object result;

        public NamedObjectAssembler(Resource name, Object result) {
            this.name = name;
            this.result = result;
        }

        public Model openModel(Resource root, Mode mode) {
            return (Model)this.open((Assembler)this, root, mode);
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            Assert.assertEquals((Object)this.name, (Object)root);
            return this.result;
        }
    }

    protected static final class FixedObjectAssembler
    extends AssemblerBase {
        private final Object x;

        protected FixedObjectAssembler(Object x) {
            this.x = x;
        }

        public Object open(Assembler a, Resource root, Mode irrelevant) {
            return this.x;
        }
    }
}

