/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelToNode {
    private final ScopePolicy scopePolicy;
    private final Allocator<Node> allocator;
    private static Allocator<Node> nodeMaker = new Allocator<Node>(){

        @Override
        public Node create(String label) {
            return Node.createAnon();
        }

        @Override
        public void reset() {
        }
    };
    private static Allocator<Node> nodeMakerDeterministic = new Allocator<Node>(){
        private long counter = 0L;

        @Override
        public Node create(String label) {
            String $ = String.format("B0x%04X", ++this.counter);
            return Node.createAnon((AnonId)new AnonId($));
        }

        @Override
        public void reset() {
        }
    };
    private static Allocator<Node> nodeMakerByLabel = new Allocator<Node>(){

        @Override
        public Node create(String label) {
            if (label == null) {
                return Node.createAnon();
            }
            return Node.createAnon((AnonId)new AnonId(label));
        }

        @Override
        public void reset() {
        }
    };

    public static LabelToNode createScopeByDocument() {
        return new LabelToNode(new SingleScopePolicy(), nodeMaker);
    }

    public static LabelToNode createScopeByGraph() {
        return new LabelToNode(new GraphScopePolicy(), nodeMaker);
    }

    public static LabelToNode createUseLabelAsGiven() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerByLabel);
    }

    public static LabelToNode createIncremental() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerDeterministic);
    }

    private LabelToNode(ScopePolicy scopePolicy, Allocator<Node> allocator) {
        this.scopePolicy = scopePolicy;
        this.allocator = allocator;
    }

    public Node get(Node scope, String label) {
        Map<String, Node> map = this.scopePolicy.getScope(scope);
        Node n = map.get(label);
        if (n == null) {
            n = this.allocator.create(label);
            map.put(label, n);
        }
        return n;
    }

    public Node create() {
        return this.allocator.create(null);
    }

    public void clear() {
        this.scopePolicy.clear();
        this.allocator.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GraphScopePolicy
    implements ScopePolicy {
        private Map<String, Node> dftMap = new HashMap<String, Node>();
        private Map<Node, Map<String, Node>> map = new HashMap<Node, Map<String, Node>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<String, Node> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<String, Node>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleScopePolicy
    implements ScopePolicy {
        private Map<String, Node> map = new HashMap<String, Node>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Allocator<T> {
        public T create(String var1);

        public void reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ScopePolicy {
        public Map<String, Node> getScope(Node var1);

        public void clear();
    }
}

