/*
 * Decompiled with CFR 0.152.
 */
package sdb.test;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import sdb.test.Env;
import sdb.test.TestStringBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class TestI18N
extends TestStringBase {
    private static final String asciiBase = "abc";
    private static final String latinBase = "\u00c3\u20ac\u00c3\u00a9\u00c3\u00ad\u00c3\u00bf";
    private static final String greekBase = "\u00ce\u00b1\u00ce\u00b2\u00ce\u00b3";
    private static final String hewbrewBase = "\u00d7?\u00d7\u2018\u00d7\u2019";
    private static final String arabicBase = "\u00d8\u00a1\u00d8\u00a2\u00d8\u00a3";
    private static final String symbolsBase = "\u00e2\u02dc\u00ba\u00e2\u02dc\u00bb\u00e2\u2122\u00aa\u00e2\u2122\u00ab";

    public TestI18N(String name, String baseString) {
        super(name, baseString, Env.test_jdbc, Env.test_params, Env.verbose);
    }

    @BeforeClass
    public static void check() {
        if (Env.test_jdbc == null) {
            System.err.println("JDBC connection is null");
        }
        if (Env.test_params == null) {
            System.err.println("Test parameters are null");
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> x = new ArrayList<Object[]>();
        x.add(new Object[]{"ASCII", asciiBase});
        x.add(new Object[]{"Accented Latin", latinBase});
        x.add(new Object[]{"Greek", greekBase});
        x.add(new Object[]{"Arabic", arabicBase});
        x.add(new Object[]{"Hewbrew", hewbrewBase});
        x.add(new Object[]{"Symbols", symbolsBase});
        return x;
    }

    private static String longString(String base, int len) {
        if (base.length() == 0) {
            return base;
        }
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            value.append(base);
            if (value.length() > len) break;
        }
        if (value.length() > len) {
            value = value.delete(len, value.length());
        }
        return value.toString();
    }
}

