/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.ArgDecl;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.test.junit.QueryTestSDBFactory;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.QueryTestSuiteFactory;
import com.hp.hpl.jena.sparql.junit.SimpleTestRunner;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import java.io.OutputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import sdb.cmd.CmdArgsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sdbtest
extends CmdArgsDB {
    public static final String usage = "sdbtest --sdb <SPEC> [--earl] [--direct] [manifest]";
    static ArgDecl earlDecl = new ArgDecl(false, "earl");
    boolean earlReport = false;
    String filename = null;

    public static void main(String ... argv) {
        new sdbtest(argv).mainRun();
    }

    protected sdbtest(String ... args) {
        super(args);
        this.add(earlDecl, "--earl", "Generate an EARL report (RDF)");
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return Utils.className((Object)((Object)this)) + " <SPEC> [--earl] [--direct] [manifest]";
    }

    protected void processModulesAndArgs() {
        if (this.getPositional().size() == 0) {
            this.cmdError("No manifest to run");
        }
        this.earlReport = this.contains(earlDecl);
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        for (String x : positionalArgs) {
            if (this.earlReport) {
                sdbtest.execOneManifestEarl(x);
                continue;
            }
            this.execOneManifest(x);
        }
    }

    private void execOneManifest(String manifest) {
        if (this.isVerbose()) {
            System.out.println("Manifest: " + manifest);
        }
        TestSuite ts = new TestSuite();
        ts.addTest((Test)QueryTestSDBFactory.make(super.getStoreDesc(), manifest, null));
        ARQ.getContext().setFalse(SDB.annotateGeneratedSQL);
        SimpleTestRunner.runAndReport((Test)ts);
    }

    static void execOneManifestEarl(String testManifest) {
        EarlReport report;
        QueryTestSuiteFactory.results = report = new EarlReport("SDB", "1.2.0", "http://jena.sf.net/SDB");
        Model model = report.getModel();
        Resource jena = model.createResource().addProperty(FOAF.homepage, (RDFNode)model.createResource("http://jena.sf.net/"));
        Resource arq = report.getSystem().addProperty(DCTerms.isPartOf, (RDFNode)jena);
        Resource who = report.getModel().createResource(FOAF.Person).addProperty(FOAF.name, "Andy Seaborne").addProperty(FOAF.homepage, (RDFNode)model.createResource("http://www.hpl.hp.com/people/afs"));
        Resource reporter = report.getReporter();
        reporter.addProperty(DC.creator, (RDFNode)who);
        TestSuite suite = QueryTestSuiteFactory.make((String)testManifest);
        SimpleTestRunner.runSilent((Test)suite);
        QueryTestSuiteFactory.results.getModel().write((OutputStream)System.out, "TTL");
    }
}

