/*
 * Decompiled with CFR 0.152.
 */
package sdb.junit;

import java.io.PrintStream;
import org.junit.internal.TextListener;
import org.junit.runner.notification.Failure;

public class TextListenerCustom
extends TextListener {
    private final PrintStream fWriter;
    static final int maxStackTrace = 10;

    public TextListenerCustom() {
        this(System.out);
    }

    public TextListenerCustom(PrintStream writer) {
        super(writer);
        this.fWriter = writer;
    }

    protected void printFailureTrace(Failure failure) {
        this.fWriter.println(failure.getMessage());
        Throwable th = failure.getException();
        if (!(th instanceof AssertionError)) {
            this.printFailureTrace(failure, 0, 10);
            return;
        }
        StackTraceElement[] stackTrace = th.getStackTrace();
        StackTraceElement el = null;
        int start = 0;
        for (start = 0; start < stackTrace.length && (el = stackTrace[start]).getClassName().equals("org.junit.Assert"); ++start) {
        }
        this.printFailureTrace(failure, start, start + 10);
    }

    private void printFailureTrace(Failure failure, int start, int finish) {
        StackTraceElement[] stackTrace = failure.getException().getStackTrace();
        if (finish > stackTrace.length) {
            finish = stackTrace.length;
        }
        for (int i = start; i < finish; ++i) {
            StackTraceElement el = stackTrace[i];
            this.fWriter.println("    " + el);
        }
    }
}

