/*
 * Decompiled with CFR 0.152.
 */
package sdb.examples;

import arq.cmd.CmdUtils;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.shared.Access;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.DatasetStore;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.store.StoreFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ExJdbcConnection {
    public static void main(String ... argv) {
        String jdbcURL = String.format("jdbc:derby:%s", "DB/test2-hash");
        JDBC.loadDriverDerby();
        Connection jdbc = ExJdbcConnection.makeConnection(jdbcURL);
        StoreDesc storeDesc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.Derby);
        System.out.println("Subjects: ");
        ExJdbcConnection.query("SELECT DISTINCT ?s { ?s ?p ?o }", storeDesc, jdbc);
        System.out.println("Predicates: ");
        ExJdbcConnection.query("SELECT DISTINCT ?p { ?s ?p ?o }", storeDesc, jdbc);
        System.out.println("Objects: ");
        ExJdbcConnection.query("SELECT DISTINCT ?o { ?s ?p ?o }", storeDesc, jdbc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void query(String queryString, StoreDesc storeDesc, Connection jdbcConnection) {
        Query query2 = QueryFactory.create((String)queryString);
        SDBConnection conn = new SDBConnection(jdbcConnection);
        Store store = StoreFactory.create(storeDesc, conn);
        Dataset ds = DatasetStore.create(store);
        QueryExecution qe = QueryExecutionFactory.create((Query)query2, (Dataset)ds);
        try {
            ResultSet rs = qe.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
        finally {
            qe.close();
        }
        store.close();
    }

    public static Connection makeConnection(String jdbcURL) {
        try {
            return DriverManager.getConnection(jdbcURL, Access.getUser(), Access.getPassword());
        }
        catch (SQLException ex) {
            throw new SDBException("SQL Exception while connecting to database: " + jdbcURL + " : " + ex.getMessage());
        }
    }

    static {
        CmdUtils.setLog4j();
    }
}

