/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.update;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.store.StoreLoaderPlus;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.vocabulary.RDF;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestStoreUpdateBase {
    Store store;
    StoreLoaderPlus loader;
    TableDescNodes nodeT;

    abstract Store getStore();

    protected int size(TableDesc desc) {
        return this.size(desc.getTableName());
    }

    protected int size(TableDescNodes desc) {
        return this.size(desc.getTableName());
    }

    protected int size(String name) {
        try {
            int size = -1;
            ResultSetJDBC result = this.store.getConnection().execQuery("SELECT COUNT(*) FROM " + name);
            if (result.get().next()) {
                size = result.get().getInt(1);
            }
            result.close();
            result = this.store.getConnection().execQuery("SELECT * FROM " + name);
            while (result.get().next()) {
                System.err.println("Row: " + result.get().getObject(1));
            }
            result.close();
            return size;
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't get size of table '" + name + "'", e);
        }
    }

    protected Node node(String str) {
        return NodeCreateUtils.create((String)str);
    }

    @Before
    public void init() throws SQLException {
        this.store = this.getStore();
        this.store.getConnection().getSqlConnection().setAutoCommit(true);
        this.loader = (StoreLoaderPlus)this.store.getLoader();
        this.nodeT = this.store.getNodeTableDesc();
    }

    @Test
    public void loadOneRemoveOne() {
        TableDescTriples desc = this.store.getTripleTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("C"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Added one triple", (long)1L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)2L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.deleteTuple(desc, this.node("B"), this.node("B"), this.node("C"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Back to the start", (long)0L, (long)this.size(desc));
    }

    @Test
    public void loadOneRemoveOneQ() {
        TableDescQuads desc = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("C"), this.node("D"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Added one triple", (long)1L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)3L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.deleteTuple(desc, this.node("B"), this.node("B"), this.node("C"), this.node("D"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Back to the start", (long)0L, (long)this.size(desc));
    }

    @Test
    public void dupeSuppressed() {
        TableDescTriples desc = this.store.getTripleTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("F"), this.node("A"), this.node("F"));
        this.loader.addTuple(desc, this.node("F"), this.node("A"), this.node("F"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added only one item", (long)1L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)2L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("G"), this.node("A"), this.node("F"));
        this.loader.finishBulkUpdate();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("G"), this.node("A"), this.node("F"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added only one item", (long)2L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)3L, (long)this.size(this.nodeT));
    }

    @Test
    public void dupeSuppressedQ() {
        TableDescQuads desc = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("F"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.addTuple(desc, this.node("F"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added only one item", (long)1L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)3L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("G"), this.node("A"), this.node("F"), this.node("K"));
        this.loader.finishBulkUpdate();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("G"), this.node("A"), this.node("F"), this.node("K"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added only one item", (long)2L, (long)this.size(desc));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)4L, (long)this.size(this.nodeT));
    }

    @Test
    public void mixItUp() {
        TableDescTriples desc1 = this.store.getTripleTableDesc();
        TableDescQuads desc2 = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc2, this.node("F"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.addTuple(desc1, this.node("A"), this.node("F"), this.node("G"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added to triples", (long)1L, (long)this.size(desc1));
        Assert.assertEquals((String)"Store added to quads", (long)1L, (long)this.size(desc2));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)3L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc2, this.node("G"), this.node("A"), this.node("F"), this.node("K"));
        this.loader.finishBulkUpdate();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc1, this.node("G"), this.node("A"), this.node("F"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store added one to triples", (long)2L, (long)this.size(desc1));
        Assert.assertEquals((String)"Store added one to quads", (long)2L, (long)this.size(desc2));
        Assert.assertEquals((String)"Store added correct number of nodes", (long)4L, (long)this.size(this.nodeT));
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc2, this.node("G"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.deleteTuple(desc1, this.node("A"), this.node("F"), this.node("G"));
        this.loader.addTuple(desc1, this.node("B"), this.node("F"), this.node("G"));
        this.loader.deleteTuple(desc2, this.node("G"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.deleteTuple(desc2, this.node("B"), this.node("A"), this.node("F"), this.node("G"));
        this.loader.addTuple(desc1, this.node("B"), this.node("B"), this.node("B"));
        this.loader.addTuple(desc2, this.node("B"), this.node("B"), this.node("B"), this.node("B"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Store triple size correct", (long)3L, (long)this.size(desc1));
        Assert.assertEquals((String)"Store quad size correct", (long)3L, (long)this.size(desc2));
        Assert.assertEquals((String)"Store nodes node size correct", (long)5L, (long)this.size(this.nodeT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void arityViolation() {
        TableDescQuads desc = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("One"));
        this.loader.finishBulkUpdate();
    }

    @Test
    public void sizes() {
        TableDescQuads desc = this.store.getTripleTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("A"), this.node("A"), this.node("A"));
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("B"));
        this.loader.finishBulkUpdate();
        desc = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("A"), this.node("A"), this.node("A"), this.node("A"));
        this.loader.addTuple(desc, this.node("B"), this.node("A"), this.node("A"), this.node("A"));
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("B"), this.node("B"));
        this.loader.addTuple(desc, this.node("B"), this.node("C"), this.node("C"), this.node("C"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Triple size right", (long)2L, (long)this.store.getSize());
        Assert.assertEquals((String)"Quad size right", (long)1L, (long)this.store.getSize(this.node("A")));
        Assert.assertEquals((String)"Quad size (2) right", (long)3L, (long)this.store.getSize(this.node("B")));
    }

    @Test
    public void rollback() {
        Model model = SDBFactory.connectDefaultModel(this.store);
        Assert.assertTrue((String)"Initially empty", (boolean)model.isEmpty());
        model.begin();
        model.add((Resource)RDF.type, RDF.type, (RDFNode)RDF.type);
        Assert.assertTrue((String)"Uncommited triple can be seen", (boolean)model.contains((Resource)RDF.type, RDF.type, (RDFNode)RDF.type));
        model.abort();
        Assert.assertTrue((String)"Nothing was added, the add aborted", (boolean)model.isEmpty());
        model.add((Resource)RDF.type, RDF.type, (RDFNode)RDF.type);
        Assert.assertEquals((String)"Model contains 1 triple", (long)1L, (long)model.size());
        model.begin();
        model.remove((Resource)RDF.type, RDF.type, (RDFNode)RDF.type);
        model.abort();
        Assert.assertEquals((String)"Model still contains 1 triple", (long)1L, (long)model.size());
    }

    @Test
    public void safeRemoveAll() {
        TableDescQuads desc = this.store.getTripleTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("A"), this.node("A"), this.node("A"));
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("B"));
        this.loader.finishBulkUpdate();
        desc = this.store.getQuadTableDesc();
        this.loader.startBulkUpdate();
        this.loader.addTuple(desc, this.node("A"), this.node("A"), this.node("A"), this.node("A"));
        this.loader.addTuple(desc, this.node("A"), this.node("A"), this.node("B"), this.node("A"));
        this.loader.addTuple(desc, this.node("B"), this.node("B"), this.node("B"), this.node("B"));
        this.loader.addTuple(desc, this.node("B"), this.node("C"), this.node("C"), this.node("C"));
        this.loader.finishBulkUpdate();
        this.loader.startBulkUpdate();
        this.loader.deleteAll();
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Triples all removed", (long)0L, (long)this.store.getSize());
        this.loader.startBulkUpdate();
        this.loader.deleteAll(this.node("A"));
        this.loader.finishBulkUpdate();
        Assert.assertEquals((String)"Quad A all removed", (long)0L, (long)this.store.getSize(this.node("A")));
        Assert.assertEquals((String)"Quad B unaffected", (long)2L, (long)this.store.getSize(this.node("B")));
    }
}

