/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.model;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.test.StoreCreator;
import com.hp.hpl.jena.sdb.test.model.AbstractTestModelSDB;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestDB2Model {
    public static Test suite() {
        TestSuite ts = new TestSuite();
        ts.addTestSuite(TestDB2IndexModel.class);
        ts.addTestSuite(TestDB2IndexQuadModel.class);
        ts.addTestSuite(TestDB2HashModel.class);
        ts.addTestSuite(TestDB2HashQuadModel.class);
        return ts;
    }

    public static class TestDB2HashQuadModel
    extends AbstractTestModelSDB {
        public TestDB2HashQuadModel(String name) {
            super(name);
        }

        public Model getModel() {
            Store store = StoreCreator.getHashDB2();
            return SDBFactory.connectNamedModel(store, "http://example.com/graph");
        }
    }

    public static class TestDB2HashModel
    extends AbstractTestModelSDB {
        public TestDB2HashModel(String name) {
            super(name);
        }

        public Model getModel() {
            Store store = StoreCreator.getHashDB2();
            return SDBFactory.connectDefaultModel(store);
        }
    }

    public static class TestDB2IndexQuadModel
    extends AbstractTestModelSDB {
        public TestDB2IndexQuadModel(String name) {
            super(name);
        }

        public Model getModel() {
            Store store = StoreCreator.getIndexDB2();
            return SDBFactory.connectNamedModel(store, "http://example.com/graph");
        }
    }

    public static class TestDB2IndexModel
    extends AbstractTestModelSDB {
        public TestDB2IndexModel(String name) {
            super(name);
        }

        public Model getModel() {
            Store store = StoreCreator.getIndexDB2();
            return SDBFactory.connectDefaultModel(store);
        }
    }
}

