/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.misc;

import com.hp.hpl.jena.sdb.exprmatch.ActionMatchBind;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchExact;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchNoBind;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchString;
import com.hp.hpl.jena.sdb.exprmatch.ActionMatchVar;
import com.hp.hpl.jena.sdb.exprmatch.ExprMatcher;
import com.hp.hpl.jena.sdb.exprmatch.MapAction;
import com.hp.hpl.jena.sdb.exprmatch.MapResult;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestExprMatch {
    @Test
    public void match_0() {
        MapAction mapAction = new MapAction();
        this.match("?x", "?a", mapAction, null);
    }

    @Test
    public void match_1() {
        MapAction mapAction = new MapAction();
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a"), "?x");
        this.match("?x", "?a", mapAction, null);
    }

    @Test
    public void match_2() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a"), new ActionMatchVar());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a"), ExprUtils.parse((String)"?x"));
        this.match("?x", "?a", mapAction, mapResult);
    }

    @Test
    public void match_3() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a"), new ActionMatchNoBind());
        MapResult mapResult = new MapResult();
        this.match("?x", "?a", mapAction, mapResult);
    }

    @Test
    public void match_4() {
        MapAction mapAction = new MapAction();
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a"), "1");
        this.match("1", "?a", mapAction, mapResult);
    }

    @Test
    public void match_5() {
        MapAction mapAction = new MapAction();
        this.noMatch("?a", "1", mapAction);
    }

    @Test
    public void struct_1() {
        MapAction mapAction = new MapAction();
        MapResult mapResult = new MapResult();
        this.match("1+2=3", "(1+2)=3", mapAction, null);
    }

    @Test
    public void struct_2() {
        MapAction mapAction = new MapAction();
        MapResult mapResult = new MapResult();
        this.match("1+2+3", "(1+2)+3", mapAction, null);
    }

    @Test
    public void struct_3() {
        MapAction mapAction = new MapAction();
        this.noMatch("1+2+3", "1+(2+3)", mapAction);
    }

    @Test
    public void cond_1() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchBind());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "3");
        this.match("?x < 3", "?a1 < ?a2", mapAction, mapResult);
    }

    @Test
    public void cond_2() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchBind());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "3");
        this.noMatch("?x < 3", "?a1 > ?a2", mapAction);
    }

    @Test
    public void regex_1() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "'smith'");
        this.match("regex(?x , 'smith')", "regex(?a1 , ?a2)", mapAction, mapResult);
    }

    @Test
    public void regex_2() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchString());
        this.noMatch("regex(?x , 'smith')", "regex(?a1 , ?a2, ?a3)", mapAction);
    }

    @Test
    public void regex_3() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchString());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "'smith'");
        mapResult.put(Var.alloc((String)"a3"), "'i'");
        this.match("regex(?x , 'smith', 'i')", "regex(?a1, ?a2, ?a3)", mapAction, mapResult);
    }

    @Test
    public void regex_4() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchExact("'i'"));
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "'smith'");
        mapResult.put(Var.alloc((String)"a3"), "'i'");
        this.match("regex(?x , 'smith', 'i')", "regex(?a1, ?a2, ?a3)", mapAction, mapResult);
    }

    @Test
    public void regex_5() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        this.noMatch("regex(?x , 'smith', 'i')", "regex(?a1, ?a2)", mapAction);
    }

    @Test
    public void regex_6() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchExact("'i'"));
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "str(?x)");
        mapResult.put(Var.alloc((String)"a2"), "'smith'");
        mapResult.put(Var.alloc((String)"a3"), "'i'");
        this.match("regex(str(?x) , 'smith', 'i')", "regex(?a1, ?a2, ?a3)", mapAction, mapResult);
    }

    @Test
    public void regex_7() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchExact("'i'"));
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        mapResult.put(Var.alloc((String)"a2"), "'smith'");
        mapResult.put(Var.alloc((String)"a3"), "'i'");
        this.match("regex(str(?x) , 'smith', 'i')", "regex(str(?a1), ?a2, ?a3)", mapAction, mapResult);
    }

    @Test
    public void regex_8() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a2"), new ActionMatchString());
        mapAction.put(Var.alloc((String)"a3"), new ActionMatchExact("'i'"));
        this.noMatch("regex(?x , 'smith', 'i')", "regex(str(?a1), ?a2, ?a3)", mapAction);
    }

    @Test
    public void function_1() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        this.match("fn:not(?x)", "fn:not(?a1)", mapAction, mapResult);
    }

    @Test
    public void function_2() {
        MapAction mapAction = new MapAction();
        mapAction.put(Var.alloc((String)"a1"), new ActionMatchVar());
        MapResult mapResult = new MapResult();
        mapResult.put(Var.alloc((String)"a1"), "?x");
        this.noMatch("fn:not(?x)", "fn:notNot(?a1)", mapAction);
    }

    private MapResult match(String expr, String pattern, MapAction aMap, MapResult expected) {
        MapResult rMap = ExprMatcher.match(expr, pattern, aMap);
        Assert.assertNotNull((Object)rMap);
        if (expected != null) {
            Assert.assertEquals((Object)expected, (Object)rMap);
        }
        return rMap;
    }

    private void noMatch(String expr, String pattern, MapAction aMap) {
        MapResult rMap = ExprMatcher.match(expr, pattern, aMap);
        Assert.assertNull((Object)rMap);
    }
}

