/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.misc;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.StoreFactory;
import com.hp.hpl.jena.sdb.test.junit.ParamAllStoreDesc;
import java.sql.Connection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestConnection
extends ParamAllStoreDesc {
    Connection conn;

    public TestConnection(String name, StoreDesc storeDesc) {
        super(name, storeDesc);
    }

    @Before
    public void before() {
        this.conn = SDBFactory.createSqlConnection(this.storeDesc.connDesc);
    }

    @Test
    public void connection_1() {
        SDBConnection conn1 = SDBFactory.createConnection(this.conn);
        Store store1 = StoreFactory.create(this.storeDesc, conn1);
        store1.getTableFormatter().format();
        SDBConnection conn2 = SDBFactory.createConnection(this.conn);
        Store store2 = StoreFactory.create(this.storeDesc, conn2);
        Model model1 = SDBFactory.connectDefaultModel(store1);
        Model model2 = SDBFactory.connectDefaultModel(store2);
        Resource s = model1.createResource();
        Property p = model1.createProperty("http://example/p");
        model1.add(s, p, "model1");
        model2.add(s, p, "model2");
        Assert.assertEquals((long)2L, (long)model1.size());
        Assert.assertEquals((long)2L, (long)model2.size());
        Assert.assertTrue((boolean)model1.isIsomorphicWith(model2));
    }
}

