/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.test.junit.QueryTestSDB;
import com.hp.hpl.jena.sdb.test.junit.StoreList;
import com.hp.hpl.jena.sdb.util.Pair;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.junit.SurpressedTest;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.junit.TestQueryUtils;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import com.hp.hpl.jena.util.junit.TestUtils;
import junit.framework.Test;
import junit.framework.TestSuite;

public class QueryTestSDBFactory
extends TestFactoryManifest {
    public static EarlReport results = null;
    StoreDesc storeDesc;
    private String testRootName;

    public static TestSuite makeSuite(String storeListFile, String manifestFile) {
        TestSuite ts = new TestSuite();
        QueryTestSDBFactory.make(ts, storeListFile, manifestFile);
        return ts;
    }

    public static void make(TestSuite ts, String storeList, String manifestFile) {
        for (Pair<String, StoreDesc> p : StoreList.stores(storeList)) {
            String label = p.car();
            StoreDesc storeDesc = p.cdr();
            if (label != null && !label.equals("")) {
                label = label + " - ";
            }
            TestSuite ts2 = QueryTestSDBFactory.make(storeDesc, manifestFile, label);
            ts.addTest((Test)ts2);
        }
    }

    public static TestSuite make(StoreDesc storeDesc, String manifestFile, String testRootName) {
        QueryTestSDBFactory f = new QueryTestSDBFactory(storeDesc, testRootName);
        TestSuite ts = f.process(manifestFile);
        if (testRootName != null) {
            ts.setName(testRootName + ts.getName());
        }
        return ts;
    }

    private QueryTestSDBFactory(StoreDesc storeDesc, String testRootName) {
        this.storeDesc = storeDesc;
        this.testRootName = testRootName;
    }

    public Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        Resource action2;
        Syntax querySyntax = TestQueryUtils.getQuerySyntax((Resource)manifest);
        if (this.testRootName != null) {
            testName = this.testRootName + testName;
        }
        if (!(querySyntax == null || querySyntax.equals((Object)Syntax.syntaxRDQL) || querySyntax.equals((Object)Syntax.syntaxARQ) || querySyntax.equals((Object)Syntax.syntaxSPARQL))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        Resource defaultTestType = TestUtils.getResource((Resource)manifest, (Property)TestManifestX.defaultTestType);
        TestItem testItem = new TestItem(entry, defaultTestType, querySyntax, DataFormat.langXML);
        QueryTestSDB test = null;
        if (testItem.getTestType() != null) {
            if (testItem.getTestType().equals(TestManifestX.TestQuery)) {
                test = new QueryTestSDB(this.storeDesc, testName, results, testItem);
            }
            if (testItem.getTestType().equals(TestManifestX.TestSurpressed)) {
                test = new SurpressedTest(testName, results, testItem);
            }
            if (test == null) {
                System.err.println("Unrecognized test type: " + testItem.getTestType());
            }
        }
        if (test == null) {
            test = new QueryTestSDB(this.storeDesc, testName, results, testItem);
        }
        if ((action2 = testItem.getAction()).hasProperty(TestManifestX.option)) {
            System.out.println("OPTION");
        }
        return test;
    }
}

