/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatasetStore;
import com.hp.hpl.jena.sdb.test.junit.StoreList;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.resultset.RSCompare;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTestSDB
extends EarlTestCase {
    public static boolean VERBOSE = false;
    StoreDesc storeDesc;
    Store store = null;
    TestItem item;
    private static Log log = LogFactory.getLog(QueryTestSDB.class);
    static String currentTestName = null;
    static List<String> lastDftLoaded = new ArrayList<String>();
    static List<String> lastNamedLoaded = new ArrayList<String>();
    boolean skipThisTest = false;

    public QueryTestSDB(StoreDesc desc, String testName, EarlReport report, TestItem item) {
        super(testName, item.getURI(), report);
        this.storeDesc = desc;
        this.item = item;
    }

    public void setUp() {
        if (currentTestName != null) {
            log.warn((Object)(this.getName() + " : Already in test '" + currentTestName + "'"));
            this.skipThisTest = true;
            return;
        }
        currentTestName = this.getName();
        final List filenamesDft = this.item.getDefaultGraphURIs();
        final List filenamesNamed = this.item.getNamedGraphURIs();
        try {
            this.store = StoreList.testStore(this.storeDesc);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
        if (!StoreList.inMem(this.store) && ((Object)lastDftLoaded).equals(filenamesDft) && ((Object)lastNamedLoaded).equals(filenamesNamed)) {
            return;
        }
        this.store.getTableFormatter().truncate();
        this.store.getConnection().executeInTransaction(new Command(){

            public Object execute() {
                for (String fn : filenamesDft) {
                    StoreUtils.load(QueryTestSDB.this.store, fn);
                }
                for (String fn : filenamesNamed) {
                    StoreUtils.load(QueryTestSDB.this.store, fn, fn);
                }
                return null;
            }
        });
        lastDftLoaded = filenamesDft;
        lastNamedLoaded = filenamesNamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        if (this.store != null) {
            this.store.close();
            this.store.getConnection().close();
            if (StoreUtils.isOracle(this.store)) {
                try {
                    QueryTestSDB queryTestSDB = this;
                    synchronized (queryTestSDB) {
                        ((Object)((Object)this)).wait(200L);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.store = null;
        currentTestName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestForReal() {
        if (this.skipThisTest) {
            log.info((Object)(this.getName() + " : Skipped"));
            return;
        }
        if (this.store == null) {
            QueryTestSDB.fail((String)"No store");
        }
        Query query2 = QueryFactory.read((String)this.item.getQueryFile());
        if (VERBOSE) {
            System.out.println("Test: " + this.getName());
            System.out.println(query2);
        }
        Object oldValue = ARQ.getContext().get(ARQ.strictGraph);
        ARQ.setTrue((Symbol)ARQ.strictGraph);
        Dataset ds = DatasetFactory.create((List)this.item.getDefaultGraphURIs(), (List)this.item.getNamedGraphURIs());
        ARQ.getContext().set(ARQ.strictGraph, oldValue);
        ResultSet rs = this.item.getResultSet();
        ResultSetRewindable rs1 = null;
        String expectedLabel = "";
        if (rs != null) {
            rs1 = ResultSetFactory.makeRewindable((ResultSet)rs);
            expectedLabel = "Results file";
        } else {
            QueryEngineFactory f = QueryEngineRef.getFactory();
            QueryExecutionBase qExec1 = new QueryExecutionBase(query2, ds, null, f);
            rs1 = ResultSetFactory.makeRewindable((ResultSet)qExec1.execSelect());
            qExec1.close();
            expectedLabel = "Standard engine";
        }
        QueryEngineFactory f2 = QueryEngineSDB.getFactory();
        ds = DatasetStore.create(this.store);
        QueryExecutionBase qExec2 = new QueryExecutionBase(query2, ds, null, f2);
        try {
            SDBConnection.logSQLExceptions = true;
            rs = qExec2.execSelect();
            ResultSetRewindable rs2 = ResultSetFactory.makeRewindable((ResultSet)rs);
            boolean b = RSCompare.same((ResultSet)rs1, (ResultSet)rs2);
            if (!b) {
                rs1.reset();
                rs2.reset();
                System.out.println("------------------- " + this.getName());
                System.out.printf("**** Expected (%s)", expectedLabel);
                ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs1);
                System.out.println("**** Got (SDB engine)");
                ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs2);
            }
            QueryTestSDB.assertTrue((String)"Results sets not the same", (boolean)b);
        }
        finally {
            SDBConnection.logSQLExceptions = false;
        }
    }
}

