/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.iterator;

import com.hp.hpl.jena.sdb.iterator.Stream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TestAlg {
    List<String> data0 = new ArrayList<String>();
    List<String> data1 = new ArrayList<String>();
    List<String> data2;

    public TestAlg() {
        this.data1.add("a");
        this.data2 = new ArrayList<String>();
        this.data2.add("x");
        this.data2.add("y");
        this.data2.add("z");
    }

    @Test
    public void append_1() {
        Iterator<String> iter = Stream.append(this.data1, this.data0).iterator();
        Assert.assertEquals((Object)"a", (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void append_2() {
        Iterator<String> iter = Stream.append(this.data0, this.data1).iterator();
        Assert.assertEquals((Object)"a", (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void append_3() {
        Iterator<String> iter = Stream.append(this.data1, this.data2).iterator();
        Assert.assertEquals((Object)"a", (Object)iter.next());
        Assert.assertEquals((Object)"x", (Object)iter.next());
        Assert.assertEquals((Object)"y", (Object)iter.next());
        Assert.assertEquals((Object)"z", (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void asString_1() {
        String x = Stream.asString(this.data0, "");
        Assert.assertEquals((Object)"", (Object)x);
    }

    @Test
    public void asString_2() {
        String x = Stream.asString(this.data1, "");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_3() {
        String x = Stream.asString(this.data1, "/");
        Assert.assertEquals((Object)"a", (Object)x);
    }

    @Test
    public void asString_4() {
        String x = Stream.asString(this.data2, "/");
        Assert.assertEquals((Object)"x/y/z", (Object)x);
    }
}

