/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.test.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.test.StoreCreator;
import com.hp.hpl.jena.sdb.test.graph.AbstractTestGraphSDB;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestOracleGraph {
    public static Test suite() {
        TestSuite ts = new TestSuite();
        ts.addTestSuite(TestOracleIndexGraph.class);
        ts.addTestSuite(TestOracleIndexQuadGraph.class);
        ts.addTestSuite(TestOracleHashGraph.class);
        ts.addTestSuite(TestOracleHashQuadGraph.class);
        return ts;
    }

    public static class TestOracleHashQuadGraph
    extends AbstractTestGraphSDB {
        public TestOracleHashQuadGraph(String arg0) {
            super(arg0);
        }

        public Graph getGraph() {
            Store store = StoreCreator.getHashOracle();
            return SDBFactory.connectNamedGraph(store, "http://example.com/graph");
        }
    }

    public static class TestOracleHashGraph
    extends AbstractTestGraphSDB {
        public TestOracleHashGraph(String arg0) {
            super(arg0);
        }

        public Graph getGraph() {
            Store store = StoreCreator.getHashOracle();
            return SDBFactory.connectDefaultGraph(store);
        }
    }

    public static class TestOracleIndexQuadGraph
    extends AbstractTestGraphSDB {
        public TestOracleIndexQuadGraph(String arg0) {
            super(arg0);
        }

        public Graph getGraph() {
            Store store = StoreCreator.getIndexOracle();
            return SDBFactory.connectNamedGraph(store, "http://example.com/graph");
        }
    }

    public static class TestOracleIndexGraph
    extends AbstractTestGraphSDB {
        public TestOracleIndexGraph(String arg0) {
            super(arg0);
        }

        public Graph getGraph() {
            Store store = StoreCreator.getIndexOracle();
            return SDBFactory.connectDefaultGraph(store);
        }
    }
}

