/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDesc {
    private String tableName;
    private List<String> columnNames = new ArrayList<String>();

    public TableDesc(String tableName) {
        this(tableName, (String[])null);
    }

    public TableDesc(String tableName, String ... colNames) {
        this.tableName = tableName;
        if (colNames != null) {
            for (int i = 0; i < colNames.length; ++i) {
                if (colNames[i] == null) continue;
                this.columnNames.add(colNames[i]);
            }
        }
    }

    public TableDesc(String tableName, List<String> colNames) {
        this.tableName = tableName;
        this.columnNames = colNames;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasColumn(String colName) {
        return this.columnNames.contains(colName);
    }

    public List<String> getColNames() {
        return this.columnNames;
    }

    public int getWidth() {
        return this.columnNames.size();
    }

    public Iterator<String> colNames() {
        return this.columnNames.iterator();
    }

    public String toString() {
        return this.tableName;
    }
}

