/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.sparql.util.Printable;
import com.hp.hpl.jena.sparql.util.PrintableBase;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Feature
extends PrintableBase
implements Named,
Printable {
    Name name;
    Object value;
    private Log log = LogFactory.getLog(Feature.class);

    private Feature(Name name) {
        this.name = name;
    }

    public Feature(Name name, String value) {
        this(name);
        this.value = value;
    }

    public Feature(Name name, long value) {
        this(name);
        this.value = value;
    }

    public Object getAsObject() {
        return this.value;
    }

    public String getAsString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        this.log.warn((Object)("Not a string: " + (Object)((Object)this)));
        return null;
    }

    public long getAsInteger() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        this.log.warn((Object)("Not a long: " + (Object)((Object)this)));
        return -1L;
    }

    public int hashCode() {
        return this.name.hashCode() | this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Feature)) {
            return false;
        }
        Feature f = (Feature)((Object)other);
        return f.name.equals((Object)this.name) && f.value.equals(this.value);
    }

    public String getName() {
        return this.name.getSymbol();
    }

    public void output(IndentedWriter out) {
        out.print((Object)this.toString());
    }

    public String toString() {
        return (Object)((Object)this.name) + "=" + this.value;
    }

    public static class Name
    extends Symbol {
        public Name(Symbol other) {
            super(other);
        }

        public Name(String nameStr) {
            super(nameStr);
        }
    }
}

