/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.graph.GraphSDB;
import com.hp.hpl.jena.sdb.layout1.StoreRDB;
import com.hp.hpl.jena.sdb.shared.SDBNotImplemented;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetStoreGraph
implements DatasetGraph {
    Store store;
    Graph defaultGraph = null;
    Lock lock = new LockMRSW();

    public DatasetStoreGraph(Store store) {
        this.store = store;
    }

    public DatasetStoreGraph(Store store, GraphSDB graph) {
        this.store = store;
        this.defaultGraph = graph;
    }

    public DatasetStoreGraph(StoreRDB store) {
        this.store = store;
        this.defaultGraph = SDBFactory.connectDefaultGraph(store);
    }

    public Store getStore() {
        return this.store;
    }

    public Iterator<Node> listGraphNodes() {
        return StoreUtils.storeGraphNames(this.store);
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean containsGraph(Node gn) {
        throw new SDBNotImplemented("DatasetStore.containsGraph");
    }

    public Graph getDefaultGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = new GraphSDB(this.store);
        }
        return this.defaultGraph;
    }

    public Graph getGraph(Node gn) {
        return new GraphSDB(this.store, gn);
    }

    public int size() {
        return -1;
    }

    public void close() {
        this.store.close();
    }
}

