/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.SDBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MySQLEngineType {
    MyISAM{

        public String getEngineName() {
            return "MyISAM";
        }
    }
    ,
    InnoDB{

        public String getEngineName() {
            return "InnoDB";
        }
    }
    ,
    Memory{

        public String getEngineName() {
            return "MEMORY";
        }
    }
    ,
    BDB{

        public String getEngineName() {
            return "BDB";
        }
    }
    ,
    NDB{

        public String getEngineName() {
            return "NDB";
        }
    };


    public abstract String getEngineName();

    public static MySQLEngineType convert(String engineName) {
        if (MySQLEngineType.check(engineName, MyISAM)) {
            return MyISAM;
        }
        if (MySQLEngineType.check(engineName, InnoDB)) {
            return InnoDB;
        }
        if (MySQLEngineType.check(engineName, Memory)) {
            return Memory;
        }
        if (MySQLEngineType.check(engineName, BDB)) {
            return BDB;
        }
        if (MySQLEngineType.check(engineName, NDB)) {
            return NDB;
        }
        throw new SDBException("Can't turn '" + engineName + "' into an engine type");
    }

    private static boolean check(String engineName, MySQLEngineType t) {
        return engineName.equalsIgnoreCase(t.getEngineName());
    }
}

