/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.scoreplanner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;

class TripleScorer {
    public static final Node BOUND = NodeCreateUtils.create((String)"BOUND");
    public static final Node UNBOUND = NodeCreateUtils.create((String)"UNBOUND");
    private Node subject;
    private Node predicate;
    private Node object;
    private int score;

    public TripleScorer(Node subject, Node predicate, Node object, int score) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.score = score;
    }

    public int score(Triple triple) {
        if (this.match(triple.getSubject(), this.subject) && this.match(triple.getPredicate(), this.predicate) && this.match(triple.getObject(), this.object)) {
            return this.score;
        }
        return 0;
    }

    private boolean match(Node node, Node match) {
        if (match == null) {
            return true;
        }
        if (match == BOUND && node.isConcrete()) {
            return true;
        }
        if (match == UNBOUND && !node.isConcrete()) {
            return true;
        }
        return node.equals((Object)match);
    }
}

