/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.modify;

import com.hp.hpl.jena.sdb.iterator.Iter;
import com.hp.hpl.jena.sdb.modify.GraphStoreSDB;
import com.hp.hpl.jena.sdb.modify.UpdateProcessorVisitorSDB;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorFactory;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorRegistry;
import com.hp.hpl.jena.sparql.modify.UpdateVisitor;
import com.hp.hpl.jena.sparql.modify.op.Update;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateProcessorSDB
implements UpdateProcessor {
    private UpdateRequest request;
    private Binding inputBinding;
    private GraphStoreSDB graphStore;

    public UpdateProcessorSDB(GraphStoreSDB graphStore, UpdateRequest request, Binding inputBinding) {
        this.graphStore = graphStore;
        this.request = request;
        this.inputBinding = inputBinding;
    }

    public void execute() {
        UpdateProcessorVisitorSDB v = new UpdateProcessorVisitorSDB(this.graphStore, this.inputBinding);
        Iter iter = Iter.convert(this.request.getUpdates().iterator());
        while (iter.hasNext()) {
            Update update = (Update)iter.next();
            update.visit((UpdateVisitor)v);
        }
    }

    public static UpdateProcessorFactory getFactory() {
        return new UpdateProcessorFactory(){

            public boolean accept(UpdateRequest request, GraphStore graphStore) {
                return graphStore instanceof GraphStoreSDB;
            }

            public UpdateProcessor create(UpdateRequest request, GraphStore graphStore, Binding inputBinding) {
                return new UpdateProcessorSDB((GraphStoreSDB)graphStore, request, inputBinding);
            }
        };
    }

    public static void register() {
        UpdateProcessorRegistry.get().add(UpdateProcessorSDB.getFactory());
    }
}

