/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.modify;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.update.GraphStore;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphStoreSDB
implements GraphStore {
    private Store store;

    public GraphStoreSDB(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }

    public void startRequest() {
    }

    public void finishRequest() {
    }

    public Dataset toDataset() {
        return SDBFactory.connectDataset(this.store);
    }

    public void addGraph(Node graphName, Graph graph) {
    }

    public Graph removeGraph(Node graphName) {
        return null;
    }

    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't change the default graph in an existing store");
    }

    public boolean containsGraph(Node graphNode) {
        return StoreUtils.containsGraph(this.store, graphNode);
    }

    public Graph getDefaultGraph() {
        return SDBFactory.connectDefaultGraph(this.store);
    }

    public Graph getGraph(Node graphNode) {
        return SDBFactory.connectNamedGraph(this.store, graphNode);
    }

    public Lock getLock() {
        throw new UnsupportedOperationException("Locking must be over all stores on this connection");
    }

    public Iterator<Node> listGraphNodes() {
        return StoreUtils.storeGraphNames(this.store);
    }

    public int size() {
        return -1;
    }

    public void clear(Node n) {
        Graph g = n != null ? SDBFactory.connectNamedGraph(this.store, n) : SDBFactory.connectDefaultGraph(this.store);
        g.getBulkUpdateHandler().removeAll();
    }

    public void close() {
        this.store.close();
    }
}

