/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.layout2.NodeLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sdb.store.TupleLoaderOne;
import com.hp.hpl.jena.sdb.util.StrUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TupleLoaderOneIndex
extends TupleLoaderOne {
    private static Log log = LogFactory.getLog(TupleLoaderOneIndex.class);

    public TupleLoaderOneIndex(SDBConnection connection) {
        super(connection);
    }

    public TupleLoaderOneIndex(SDBConnection connection, TableDesc tableDesc) {
        super(connection, tableDesc);
    }

    public TupleLoaderOneIndex(Store store, TableDesc tableDesc) {
        super(store.getConnection(), tableDesc);
    }

    public SqlConstant getRefForNode(Node node) throws SQLException {
        return new SqlConstant(TupleLoaderOneIndex.getIndex(this.connection(), node, false));
    }

    public SqlConstant insertNode(Node node) throws SQLException {
        return new SqlConstant(TupleLoaderOneIndex.getIndex(this.connection(), node, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIndex(SDBConnection conn, Node node, boolean create) throws SQLException {
        try {
            long hash = NodeLayout2.hash(node);
            String lex = NodeLayout2.nodeToLex(node);
            String hashStr = Long.toString(hash);
            String sqlStmt = StrUtils.strjoinNL("SELECT id FROM Nodes WHERE hash = " + hashStr);
            ResultSetJDBC rsx = conn.execQuery(sqlStmt);
            ResultSet rs = rsx.get();
            try {
                if (!rs.next()) {
                    if (!create) {
                        throw new SDBException("No such node in table: " + node);
                    }
                    TupleLoaderOneIndex.insertNode(conn, lex, node);
                    int n = TupleLoaderOneIndex.getIndex(conn, node, false);
                    return n;
                }
                int id = rs.getInt("id");
                if (rs.next()) {
                    log.warn((Object)("More than one hit for : " + sqlStmt + " (ignored)"));
                }
                int n = id;
                return n;
            }
            finally {
                RS.close(rsx);
            }
        }
        catch (SQLException ex) {
            log.warn((Object)("SQLException: " + ex.getMessage()));
            throw ex;
        }
    }

    private static void insertNode(SDBConnection conn, String lex, Node node) throws SQLException {
        int typeId = NodeLayout2.nodeToType(node);
        String lang = "";
        String datatype = "";
        if (node.isLiteral()) {
            lang = node.getLiteralLanguage();
            datatype = node.getLiteralDatatypeURI();
            if (datatype == null) {
                datatype = "";
            }
        }
        long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
        String sqlStmt = StrUtils.strjoinNL("INSERT INTO " + TableDescNodes.name() + "(hash,lex,lang,datatype,type) VALUES", "  (" + hash + ", ", "   " + SQLUtils.quoteStr(lex) + ", ", "   " + SQLUtils.quoteStr(lang) + ", ", "   " + SQLUtils.quoteStr(datatype) + ", ", "   " + typeId, ")");
        conn.execUpdate(sqlStmt);
    }
}

