/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.layout2.LoaderTuplesNodes;
import com.hp.hpl.jena.sdb.layout2.NodeLayout2;
import com.hp.hpl.jena.sdb.layout2.SQLBridgeFactory2;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.index.FmtLayout2IndexHSQL;
import com.hp.hpl.jena.sdb.layout2.index.QueryCompilerFactoryIndex;
import com.hp.hpl.jena.sdb.layout2.index.TableNodesIndex;
import com.hp.hpl.jena.sdb.layout2.index.TupleLoaderIndexHSQL;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.store.StoreBaseHSQL;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoreTriplesNodesIndexHSQL
extends StoreBaseHSQL {
    public StoreTriplesNodesIndexHSQL(SDBConnection connection, StoreDesc desc) {
        super(connection, desc, new FmtLayout2IndexHSQL(connection), new LoaderTuplesNodes(connection, TupleLoaderIndexHSQL.class), new QueryCompilerFactoryIndex(), new SQLBridgeFactory2(), new TableDescTriples(), new TableDescQuads(), new TableNodesIndex());
        ((LoaderTuplesNodes)this.getLoader()).setStore(this);
    }

    public long getSize(Node node) {
        String lex = NodeLayout2.nodeToLex(node);
        int typeId = NodeLayout2.nodeToType(node);
        String lang = "";
        String datatype = "";
        if (node.isLiteral()) {
            lang = node.getLiteralLanguage();
            datatype = node.getLiteralDatatypeURI();
            if (datatype == null) {
                datatype = "";
            }
        }
        long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
        try {
            ResultSet res = this.getConnection().exec("SELECT id FROM Nodes WHERE hash = " + hash).get();
            int id = -1;
            if (!res.next()) {
                res.close();
                return 0L;
            }
            id = res.getInt(1);
            res.close();
            res = this.getConnection().exec("SELECT COUNT(*) FROM " + this.getQuadTableDesc().getTableName() + " WHERE g = " + id).get();
            res.next();
            long result = res.getLong(1);
            res.close();
            return result;
        }
        catch (SQLException e) {
            throw new SDBExceptionSQL("Failed to get graph size", e);
        }
    }
}

