/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.compiler.QueryCompilerFactory;
import com.hp.hpl.jena.sdb.layout2.NodeLayout2;
import com.hp.hpl.jena.sdb.layout2.StoreBase;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.index.TableNodesIndex;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sdb.store.SQLGenerator;
import com.hp.hpl.jena.sdb.store.StoreFormatter;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoreBaseIndex
extends StoreBase {
    public StoreBaseIndex(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, StoreLoader loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, SQLGenerator sqlGenerator) {
        super(connection, desc, formatter, loader, compilerF, sqlBridgeF, sqlGenerator, new TableDescTriples(), new TableDescQuads(), new TableNodesIndex());
    }

    public long getSize(Node node) {
        String lex = NodeLayout2.nodeToLex(node);
        int typeId = NodeLayout2.nodeToType(node);
        String lang = "";
        String datatype = "";
        if (node.isLiteral()) {
            lang = node.getLiteralLanguage();
            datatype = node.getLiteralDatatypeURI();
            if (datatype == null) {
                datatype = "";
            }
        }
        long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
        try {
            ResultSet res = this.getConnection().exec("SELECT id FROM Nodes WHERE hash = " + hash).get();
            int id = -1;
            if (!res.next()) {
                res.close();
                return 0L;
            }
            id = res.getInt(1);
            res.close();
            res = this.getConnection().exec("SELECT COUNT(*) FROM " + this.getQuadTableDesc().getTableName() + " WHERE g = " + id).get();
            res.next();
            long result = res.getLong(1);
            res.close();
            return result;
        }
        catch (SQLException e) {
            throw new SDBExceptionSQL("Failed to get graph size", e);
        }
    }
}

