/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.layout2.NodeLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.store.TableDesc;
import com.hp.hpl.jena.sdb.store.TupleLoaderOne;
import com.hp.hpl.jena.sdb.util.StrUtils;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TupleLoaderOneHash
extends TupleLoaderOne {
    public TupleLoaderOneHash(SDBConnection connection) {
        super(connection);
    }

    public TupleLoaderOneHash(SDBConnection connection, TableDesc tableDesc) {
        super(connection, tableDesc);
    }

    public TupleLoaderOneHash(Store store, TableDesc tableDesc) {
        super(store.getConnection(), tableDesc);
    }

    public SqlConstant getRefForNode(Node node) throws SQLException {
        return new SqlConstant(NodeLayout2.hash(node));
    }

    public SqlConstant insertNode(Node node) throws SQLException {
        int typeId = NodeLayout2.nodeToType(node);
        String lex = NodeLayout2.nodeToLex(node);
        String lang = "";
        String datatype = "";
        if (node.isLiteral()) {
            lang = node.getLiteralLanguage();
            datatype = node.getLiteralDatatypeURI();
            if (datatype == null) {
                datatype = "";
            }
        }
        long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
        String sqlStmtTest = StrUtils.strjoinNL("SELECT hash FROM " + TableDescNodes.name(), "WHERE hash = " + hash);
        ResultSetJDBC rsx = this.connection().execQuery(sqlStmtTest);
        ResultSet rs = rsx.get();
        boolean b = rs.next();
        rsx.close();
        if (b) {
            return new SqlConstant(hash);
        }
        String sqlStmt = StrUtils.strjoinNL("INSERT INTO " + TableDescNodes.name() + "(hash,lex,lang,datatype,type) VALUES", "  (" + hash + ", ", "   " + SQLUtils.quoteStr(lex) + ", ", "   " + SQLUtils.quoteStr(lang) + ", ", "   " + SQLUtils.quoteStr(datatype) + ", ", "   " + typeId, ")");
        this.connection().execUpdate(sqlStmt);
        return new SqlConstant(hash);
    }
}

