/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.hash;

import com.hp.hpl.jena.sdb.layout2.FmtLayout2;
import com.hp.hpl.jena.sdb.layout2.TableDescNodes;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.TableDescTriples;
import com.hp.hpl.jena.sdb.layout2.TablePrefixes;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.SQLException;

public class FmtLayout2HashDB2
extends FmtLayout2 {
    public FmtLayout2HashDB2(SDBConnection connection) {
        super(connection);
    }

    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g BIGINT NOT NULL,", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash BIGINT NOT NULL,", "   lex CLOB NOT NULL,", "   lang VARCHAR(10),", "   datatype VARCHAR(200),", "   type INTEGER  NOT NULL,", "   PRIMARY KEY (hash)", ") CCSID UNICODE"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix VARCHAR(50) NOT NULL,", "    uri VARCHAR(500) ,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    protected void truncateTable(String tableName) {
        try {
            this.connection().exec("DELETE FROM " + tableName);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException truncating table: " + tableName, ex);
        }
    }
}

