/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sdb.layout1.EncoderDecoder;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.lang.sparql.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.sparql.Token;
import com.hp.hpl.jena.sparql.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.Reader;
import java.io.StringReader;

public class CodecSimple
implements EncoderDecoder {
    private PrefixMapping prefixMapping;

    public CodecSimple() {
        this.prefixMapping = new PrefixMappingImpl();
    }

    public CodecSimple(PrefixMapping pMap) {
        this.prefixMapping = pMap;
    }

    public String encode(Node node) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeId().getLabelString();
        }
        String s = FmtUtils.stringForNode((Node)node, (PrefixMapping)this.prefixMapping);
        return s;
    }

    public Node decode(String s) {
        if (s.startsWith("Double")) {
            System.err.println(s);
        }
        if (s.startsWith("_:")) {
            return Node.createAnon((AnonId)new AnonId(s.substring(2)));
        }
        return CodecSimple.stringToNode(s, this.prefixMapping);
    }

    static Node stringToNode(String string, PrefixMapping pmap) {
        try {
            Query query2 = new Query();
            query2.setPrefixMapping(pmap);
            StringReader in = new StringReader(string);
            SPARQLParser p = new SPARQLParser((Reader)in);
            p.setQuery(query2);
            Node n = p.GraphTerm();
            Token t = p.getNextToken();
            if (t.kind != 0) {
                throw new ParseException("More to parse: " + t.image);
            }
            return n;
        }
        catch (TokenMgrError ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (ParseException ex) {
            if (ex.currentToken != null) {
                int x = ex.currentToken.beginColumn;
                System.out.println(string);
                for (int i = 0; i < x; ++i) {
                    System.err.print(' ');
                }
                System.err.println("^^");
            }
            System.err.println(ex.getMessage());
        }
        catch (Throwable th) {
            String m = th.getMessage();
            if (m == null) {
                m = "No Message";
            }
            System.err.println(m);
            th.printStackTrace(System.err);
        }
        return null;
    }
}

