/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.iterator;

import com.hp.hpl.jena.sdb.iterator.AccString;
import com.hp.hpl.jena.sdb.iterator.Accumulate;
import com.hp.hpl.jena.sdb.iterator.Action;
import com.hp.hpl.jena.sdb.iterator.ActionKeyValue;
import com.hp.hpl.jena.sdb.iterator.Filter;
import com.hp.hpl.jena.sdb.iterator.FilterUnique;
import com.hp.hpl.jena.sdb.iterator.Iter;
import com.hp.hpl.jena.sdb.iterator.Iterator2;
import com.hp.hpl.jena.sdb.iterator.Transform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream {
    public static <T> Set<T> toSet(Iterable<T> stream) {
        return Stream.toSet(stream.iterator());
    }

    public static <T> Set<T> toSet(Iterator<T> stream) {
        Accumulate action = new Accumulate<T, Set<T>>(){
            private Set<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public Set<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new HashSet();
            }
        };
        return (Set)Stream.reduce(stream, action);
    }

    public static <T> List<T> toList(Iterable<? extends T> stream) {
        return Stream.toList(stream.iterator());
    }

    public static <T> List<T> toList(Iterator<? extends T> stream) {
        Accumulate action = new Accumulate<T, List<T>>(){
            private List<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public List<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new ArrayList();
            }
        };
        return (List)Stream.reduce(stream, action);
    }

    public static <T, R> R reduce(Iterable<? extends T> stream, Accumulate<T, R> aggregator) {
        return Stream.reduce(stream.iterator(), aggregator);
    }

    public static <T, R> R reduce(Iterator<? extends T> stream, Accumulate<T, R> aggregator) {
        aggregator.start();
        while (stream.hasNext()) {
            T item = stream.next();
            aggregator.accumulate(item);
        }
        return aggregator.get();
    }

    public static <T> void apply(Iterable<? extends T> stream, Action<T> action) {
        Stream.apply(stream.iterator(), action);
    }

    public static <T> void apply(Iterator<? extends T> stream, Action<T> action) {
        while (stream.hasNext()) {
            T item = stream.next();
            action.apply(item);
        }
    }

    public static <K, V> void apply(Map<K, V> map, ActionKeyValue<K, V> action) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <T> Iterator<T> filter(Iterable<? extends T> stream, Filter<T> filter) {
        return Stream.filter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> stream, final Filter<T> filter) {
        Iterator iter = new Iterator<T>(){
            boolean finished = false;
            T slot;

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                while (this.slot == null) {
                    if (!stream.hasNext()) {
                        this.finished = true;
                        break;
                    }
                    Object nextItem = stream.next();
                    if (!filter.accept(nextItem)) continue;
                    this.slot = nextItem;
                    break;
                }
                return this.slot != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object returnValue = this.slot;
                    this.slot = null;
                    return returnValue;
                }
                throw new NoSuchElementException("filter.next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("filter.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> notFilter(Iterable<? extends T> stream, Filter<T> filter) {
        return Stream.notFilter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> notFilter(Iterator<? extends T> stream, Filter<T> filter) {
        Filter<T> flippedFilter = InvertedFilter.invert(filter);
        return Stream.filter(stream, flippedFilter);
    }

    public static <T, R> Iterator<R> map(Iterable<? extends T> stream, Transform<T, R> converter) {
        return Stream.map(stream.iterator(), converter);
    }

    public static <T, R> Iterator<R> map(final Iterator<? extends T> stream, final Transform<T, R> converter) {
        Iterator iter = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public R next() {
                return converter.convert(stream.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("map.remove");
            }
        };
        return iter;
    }

    public static <T> Iterable<T> append(Iterable<T> iter1, Iterable<T> iter2) {
        Iterator<T> _iter1 = iter1 == null ? null : iter1.iterator();
        Iterator<T> _iter2 = iter2 == null ? null : iter2.iterator();
        return new Iterator2<T>(_iter1, _iter2);
    }

    public static <T> Iterator<T> append(Iterator<T> iter1, Iterator<T> iter2) {
        return new Iterator2<T>(iter1, iter2);
    }

    public static <T> Iterator<T> distinct(Iterable<T> iter) {
        return Stream.distinct(iter.iterator());
    }

    public static <T> Iterator<T> distinct(Iterator<T> iter) {
        return Stream.filter(iter, new FilterUnique());
    }

    public static <T> Iterator<T> convert(Iterator iterator) {
        return iterator;
    }

    public static <T> String asString(Iterable<T> stream) {
        return (String)Stream.reduce(stream, new AccString());
    }

    public static <T> String asString(Iterator<T> stream) {
        return (String)Stream.reduce(stream, new AccString());
    }

    public static <T> String asString(Iter<T> stream) {
        return (String)Stream.reduce(stream.iterator(), new AccString());
    }

    public static <T> String asString(Iterable<T> stream, String sep) {
        return (String)Stream.reduce(stream, new AccString(sep));
    }

    public static <T> String asString(Iterator<T> stream, String sep) {
        return (String)Stream.reduce(stream, new AccString(sep));
    }

    public static <T> String asString(Iter<T> stream, String sep) {
        return (String)Stream.reduce(stream.iterator(), new AccString(sep));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvertedFilter<T>
    implements Filter<T> {
        private Filter<T> baseFilter;

        public static <T> Filter<T> invert(Filter<T> filter) {
            return new InvertedFilter<T>(filter);
        }

        private InvertedFilter(Filter<T> baseFilter) {
            this.baseFilter = baseFilter;
        }

        @Override
        public boolean accept(T item) {
            return !this.baseFilter.accept(item);
        }
    }
}

