/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.iterator;

import com.hp.hpl.jena.sdb.iterator.Accumulate;
import com.hp.hpl.jena.sdb.iterator.Action;
import com.hp.hpl.jena.sdb.iterator.Filter;
import com.hp.hpl.jena.sdb.iterator.Iterator2;
import com.hp.hpl.jena.sdb.iterator.Stream;
import com.hp.hpl.jena.sdb.iterator.Transform;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iter<T>
implements Iterable<T>,
Iterator<T> {
    private Iterator<T> iterator;

    public static <T> Iter<T> iter(Iter<T> iter) {
        return iter;
    }

    public static <T> Iter<T> iter(Collection<T> collection) {
        return Iter.iter(collection.iterator());
    }

    public static <T> Iter<T> iter(Iterator<T> iterator) {
        if (iterator instanceof Iter) {
            return (Iter)iterator;
        }
        return new Iter<T>(iterator);
    }

    public static <T> Iter<T> iter(Iterable<T> iterable) {
        if (iterable instanceof Iter) {
            return (Iter)iterable;
        }
        return new Iter<T>(iterable.iterator());
    }

    public static <T> Iter<T> convert(Iterator iterator) {
        return Iter.iter(iterator);
    }

    private Iter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public Set<T> toSet() {
        return Stream.toSet(this.iterator);
    }

    public List<T> toList() {
        return Stream.toList(this.iterator);
    }

    public Iter<T> filter(Filter<T> filter) {
        return Iter.iter(Stream.filter(this.iterator, filter));
    }

    public <R> Iter<R> map(Transform<T, R> converter) {
        return Iter.iter(Stream.map(this.iterator, converter));
    }

    public <R> R reduce(Accumulate<T, R> aggregator) {
        return Stream.reduce(this.iterator, aggregator);
    }

    public void apply(Action<T> action) {
        Stream.apply(this.iterator, action);
    }

    public Iter<T> append(Iter<? extends T> iter) {
        return new Iter<T>(new Iterator2<T>(this.iterator, iter.iterator()));
    }

    public Iter<T> append(Iterable<? extends T> iter) {
        return new Iter<T>(new Iterator2<T>(this.iterator, iter.iterator()));
    }

    public Iter<T> append(Iterator<? extends T> iter) {
        return new Iter<T>(new Iterator2<T>(this.iterator, iter));
    }

    public String asString() {
        return Stream.asString(this.iterator);
    }

    public String asString(String sep) {
        return Stream.asString(this.iterator, sep);
    }

    public Iter<T> distinct() {
        return new Iter<T>(Stream.distinct(this.iterator()));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

