/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionHandlerSDB
implements TransactionHandler {
    private static Log log = LogFactory.getLog(TransactionHandlerSDB.class);
    Connection sqlConnection;
    boolean inTransaction;

    public TransactionHandlerSDB(SDBConnection connection) {
        this.sqlConnection = connection.getSqlConnection();
        this.inTransaction = false;
    }

    public boolean transactionsSupported() {
        return true;
    }

    public synchronized void begin() {
        if (this.inTransaction) {
            log.warn((Object)"beginTransaction: Already in a transaction");
            throw new SDBException("Already in transaction");
        }
        try {
            this.sqlConnection.setAutoCommit(false);
            this.inTransaction = true;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("begin", ex);
        }
    }

    public synchronized void commit() {
        if (!this.inTransaction) {
            log.warn((Object)"commit: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.commit();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("commit", ex);
        }
    }

    public synchronized void abort() {
        if (!this.inTransaction) {
            log.warn((Object)"abort: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.rollback();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("abort", ex);
        }
    }

    public synchronized void abortFinally() {
        if (!this.inTransaction) {
            return;
        }
        this.abort();
    }

    public void abortSilent() {
        try {
            this.abortFinally();
        }
        catch (SDBExceptionSQL sDBExceptionSQL) {
            // empty catch block
        }
    }

    public Object executeInTransaction(Command c) {
        try {
            this.begin();
            Object result = c.execute();
            this.commit();
            return result;
        }
        catch (SDBExceptionSQL e) {
            this.abortFinally();
            throw e;
        }
        catch (JenaException e) {
            this.abortFinally();
            throw e;
        }
        catch (Throwable e) {
            this.abortFinally();
            throw new SDBException(e);
        }
    }
}

