/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrefixMappingSDB
extends PrefixMappingImpl {
    private static Log log = LogFactory.getLog(PrefixMappingSDB.class);
    public static final String prefixTableName = "Prefixes";
    public static final int prefixColWidth = 50;
    public static final int uriColWidth = 500;
    private SDBConnection connection = null;
    private String graphName;

    public PrefixMappingSDB(String graphURI, SDBConnection sdb) {
        this.graphName = graphURI;
        this.connection = sdb;
        try {
            this.readPrefixMapping();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void set(String prefix, String uri) {
        super.set(prefix, uri);
        this.insertIntoPrefixMap(prefix, uri);
    }

    protected String get(String prefix) {
        String x = super.get(prefix);
        if (x != null) {
            return x;
        }
        return this.readFromPrefixMap(prefix);
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String uri = super.getNsPrefixURI(prefix);
        if (uri != null) {
            this.removeFromPrefixMap(prefix, uri);
        }
        super.removeNsPrefix(prefix);
        return this;
    }

    private void readPrefixMapping() {
        try {
            String sqlStmt = "SELECT prefix, uri FROM Prefixes";
            ResultSetJDBC rsx = this.connection.execSilent(sqlStmt);
            if (rsx == null || rsx.get() == null) {
                return;
            }
            ResultSet rs = rsx.get();
            while (rs.next()) {
                String p = rs.getString("prefix");
                p = this.decode(p);
                String v = rs.getString("uri");
                super.set(p, v);
            }
            rsx.close();
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("Failed to get prefixes", ex);
        }
    }

    private String readFromPrefixMap(String prefix) {
        try {
            String sqlStmt = SQLUtils.sqlStr("SELECT uri FROM Prefixes", "   WHERE prefix = " + SQLUtils.quoteStr(prefix));
            ResultSetJDBC rsx = this.connection.execQuery(sqlStmt);
            ResultSet rs = rsx.get();
            String uri = null;
            if (rs.next()) {
                String v;
                uri = v = rs.getString("uri");
                if (rs.next()) {
                    log.warn((Object)("Multiple prefix mappings for '" + prefix + "'"));
                }
            }
            rsx.close();
            return uri;
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(String.format("Failed to read prefix (%s)", prefix), ex);
        }
    }

    private void insertIntoPrefixMap(String prefix, String uri) {
        try {
            String x = this.get(prefix);
            if (x != null) {
                this.removeFromPrefixMap(prefix, x);
            }
            prefix = this.encode(prefix);
            String sqlStmt = SQLUtils.sqlStr("INSERT INTO Prefixes", "   VALUES (" + SQLUtils.quoteStr(prefix) + ", " + SQLUtils.quoteStr(uri) + ")");
            this.connection.execUpdate(sqlStmt);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(String.format("Failed to set prefix (%s,%s)", prefix, uri), ex);
        }
    }

    private void removeFromPrefixMap(String prefix, String uri) {
        try {
            prefix = this.encode(prefix);
            String sqlStmt = SQLUtils.sqlStr("DELETE FROM Prefixes WHERE", "   prefix = " + SQLUtils.quoteStr(prefix));
            this.connection.execUpdate(sqlStmt);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(String.format("Failed to remove prefix (%s,%s)", prefix, uri), ex);
        }
    }

    private String encode(String prefix) {
        return prefix + ":";
    }

    private String decode(String prefix) {
        return prefix.substring(0, prefix.length() - 1);
    }
}

