/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.graph.EventManagerSDB;
import com.hp.hpl.jena.sdb.graph.GraphQueryHandlerSDB;
import com.hp.hpl.jena.sdb.graph.PrefixMappingSDB;
import com.hp.hpl.jena.sdb.graph.UpdateHandlerSDB;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import com.hp.hpl.jena.sdb.store.StoreLoaderPlus;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphSDB
extends GraphBase
implements Graph {
    private static Log log = LogFactory.getLog(GraphSDB.class);
    protected PrefixMapping pmap = null;
    protected Store store = null;
    protected int inBulkUpdate = 0;
    protected Node graphNode = Quad.defaultGraphNode;
    protected DatasetStoreGraph datasetStore = null;

    public GraphSDB(Store store, String uri) {
        this(store, Node.createURI((String)uri));
    }

    public GraphSDB(Store store) {
        this(store, (Node)null);
    }

    public GraphSDB(Store store, Node graphNode) {
        if (graphNode == null) {
            graphNode = Quad.defaultGraphNode;
        }
        this.store = store;
        this.graphNode = graphNode;
        this.datasetStore = new DatasetStoreGraph(store, this);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public Store getStore() {
        return this.store;
    }

    public SDBConnection getConnection() {
        return this.store.getConnection();
    }

    public PrefixMapping getPrefixMapping() {
        if (this.pmap == null) {
            try {
                String graphURI = null;
                if (this.graphNode.equals((Object)Quad.defaultGraphNode)) {
                    graphURI = "";
                } else if (this.graphNode.isURI()) {
                    graphURI = this.graphNode.getURI();
                } else {
                    log.warn((Object)"Not a URI for graph name");
                    graphURI = this.graphNode.toString();
                }
                this.pmap = new PrefixMappingSDB(graphURI, this.store.getConnection());
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to get prefixes: " + ex.getMessage()));
            }
        }
        return this.pmap;
    }

    private Quad quad(TripleMatch m) {
        Node s = m.getMatchSubject();
        Var sVar = null;
        if (s == null) {
            sVar = Var.alloc((String)"s");
            s = sVar;
        }
        Node p = m.getMatchPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc((String)"p");
            p = pVar;
        }
        Node o = m.getMatchObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc((String)"o");
            o = oVar;
        }
        return new Quad(this.graphNode, s, p, o);
    }

    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        SDBRequest cxt = new SDBRequest(this.getStore(), new Query());
        Var s = m.getMatchSubject() == null ? Var.alloc((String)"s") : m.getMatchSubject();
        Var p = m.getMatchPredicate() == null ? Var.alloc((String)"p") : m.getMatchPredicate();
        Var o = m.getMatchObject() == null ? Var.alloc((String)"o") : m.getMatchObject();
        Triple triple = new Triple((Node)s, (Node)p, (Node)o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpQuadPattern op = new OpQuadPattern(this.graphNode, pattern);
        Plan plan = QueryEngineSDB.getFactory().create((Op)op, (DatasetGraph)this.datasetStore, BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        if (SDB.getContext().isTrue(SDB.streamGraphAPI)) {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            while (qIter.hasNext()) {
                bindings.add(qIter.nextBinding());
            }
            qIter.close();
            return new GraphIterator(triple, (QueryIterator)new QueryIterPlainWrapper(bindings.iterator()));
        }
        return new GraphIterator(triple, qIter);
    }

    private static Triple bindingToTriple(Triple pattern, Binding binding) {
        Node s = pattern.getSubject();
        Node p = pattern.getPredicate();
        Node o = pattern.getObject();
        Node sResult = s;
        Node pResult = p;
        Node oResult = o;
        if (Var.isVar((Node)s)) {
            sResult = binding.get(Var.alloc((Node)s));
        }
        if (Var.isVar((Node)p)) {
            pResult = binding.get(Var.alloc((Node)p));
        }
        if (Var.isVar((Node)o)) {
            oResult = binding.get(Var.alloc((Node)o));
        }
        Triple resultTriple = new Triple(sResult, pResult, oResult);
        return resultTriple;
    }

    public StoreLoader getBulkLoader() {
        return this.store.getLoader();
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new UpdateHandlerSDB(this);
        }
        return this.bulkHandler;
    }

    public QueryHandler queryHandler() {
        return new GraphQueryHandlerSDB(this, this.graphNode, this.datasetStore);
    }

    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new EventManagerSDB(this);
        }
        return this.gem;
    }

    public void performAdd(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (this.graphNode == Quad.defaultGraphNode) {
            this.store.getLoader().addTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.addQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    public void performDelete(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (this.graphNode == Quad.defaultGraphNode) {
            this.store.getLoader().deleteTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.deleteQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    public void startBulkUpdate() {
        ++this.inBulkUpdate;
        if (this.inBulkUpdate == 1) {
            this.store.getLoader().startBulkUpdate();
        }
    }

    public void finishBulkUpdate() {
        --this.inBulkUpdate;
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    public TransactionHandler getTransactionHandler() {
        return this.store.getConnection().getTransactionHandler();
    }

    public int graphBaseSize() {
        return (int)(this.graphNode == Quad.defaultGraphNode ? this.store.getSize() : this.store.getSize(this.graphNode));
    }

    public void deleteAll() {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (this.graphNode == Quad.defaultGraphNode) {
            this.store.getLoader().deleteAll();
        } else {
            ((StoreLoaderPlus)this.store.getLoader()).deleteAll(this.graphNode);
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    class GraphIterator
    extends NiceIterator {
        QueryIterator qIter;
        Triple current = null;
        Triple pattern;

        GraphIterator(Triple pattern, QueryIterator qIter) {
            this.qIter = qIter;
            this.pattern = pattern;
        }

        public void close() {
            this.qIter.close();
        }

        public boolean hasNext() {
            return this.qIter.hasNext();
        }

        public Triple next() {
            this.current = GraphSDB.bindingToTriple(this.pattern, this.qIter.nextBinding());
            return this.current;
        }

        public void remove() {
            if (this.current != null) {
                GraphSDB.this.delete(this.current);
            }
        }
    }
}

