/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.TreeQueryPlan;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.iterator.Stream;
import com.hp.hpl.jena.sdb.iterator.Transform;
import com.hp.hpl.jena.sdb.shared.SDBNotImplemented;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphQueryHandlerSDB
extends SimpleQueryHandler {
    DatasetStoreGraph datasetStore;
    Node graphNode;
    BasicPattern bgp = new BasicPattern();
    private Op op;
    private Node[] variables;
    private Map<Node, Integer> indexes;
    private Triple[] pattern;

    public GraphQueryHandlerSDB(Graph graph, Node graphNode, DatasetStoreGraph datasetStore) {
        super(graph);
        this.datasetStore = datasetStore;
        this.graphNode = graphNode;
    }

    public final TreeQueryPlan prepareTree(Graph pattern) {
        throw new SDBNotImplemented("prepareTree - Chris says this will not be called");
    }

    public BindingQueryPlan prepareBindings(Query q, Node[] variables) {
        this.variables = variables;
        this.indexes = new HashMap<Node, Integer>();
        int idx = 0;
        for (Node v : variables) {
            this.indexes.put(v, idx++);
        }
        List pattern = q.getPattern();
        for (Triple t : pattern) {
            this.bgp.add(t);
        }
        this.op = new OpQuadPattern(this.graphNode, this.bgp);
        return new BindingQueryPlanSDB();
    }

    class BindingQueryPlanSDB
    implements BindingQueryPlan {
        BindingQueryPlanSDB() {
        }

        public ExtendedIterator executeBindings() {
            Set vars = OpVars.allVars((Op)GraphQueryHandlerSDB.this.op);
            Plan plan = QueryEngineSDB.getFactory().create(GraphQueryHandlerSDB.this.op, (DatasetGraph)GraphQueryHandlerSDB.this.datasetStore, null, null);
            QueryIterator qIter = plan.iterator();
            Transform<Binding, Domain> b2d = new Transform<Binding, Domain>(){

                @Override
                public Domain convert(Binding binding) {
                    Domain d = new Domain(GraphQueryHandlerSDB.this.variables.length);
                    for (Node n : GraphQueryHandlerSDB.this.variables) {
                        Var v = Var.alloc((Node)n);
                        Node value = binding.get(v);
                        int idx = (Integer)GraphQueryHandlerSDB.this.indexes.get(v);
                        d.setElement(idx, value);
                    }
                    return d;
                }
            };
            Iterator<Domain> it = Stream.map(qIter, b2d);
            return WrappedIterator.create(it);
        }
    }
}

