/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.sqlnode.SqlCoalesce;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlDistinct;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinInner;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase0;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase1;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeBase2;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlProject;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRename;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRestrict;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSlice;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTransform;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlUnion;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Stack;

public class SqlTransformer {
    public static SqlNode transform(SqlNode sqlNode, SqlTransform transform) {
        SqlTransformVisitor v = new SqlTransformVisitor(transform);
        sqlNode.visit(v);
        return v.result();
    }

    private static class SqlTransformVisitor
    implements SqlNodeVisitor {
        Stack<SqlNode> stack = new Stack();
        private SqlTransform transform;

        public SqlTransformVisitor(SqlTransform transform) {
            this.transform = transform;
        }

        public SqlNode result() {
            if (this.stack.size() != 1) {
                ALog.warn((Object)this, (String)"Stack is not aligned");
            }
            return this.stack.pop();
        }

        private void visit0(SqlNodeBase0 n) {
            this.stack.push(n.apply(this.transform));
        }

        private void visit1(SqlNodeBase1 n1) {
            n1.getSubNode().visit(this);
            SqlNode s = this.stack.pop();
            this.stack.push(n1.apply(this.transform, s));
        }

        private void visit2(SqlNodeBase2 n2) {
            n2.getLeft().visit(this);
            SqlNode left = this.stack.pop();
            n2.getRight().visit(this);
            SqlNode right = this.stack.pop();
            this.stack.push(n2.apply(this.transform, left, right));
        }

        public void visit(SqlProject sqlProject) {
            sqlProject.getSubNode().visit(this);
            SqlNode s = this.stack.pop();
            SqlNode p = this.transform.transform(sqlProject, s);
            this.stack.push(p);
        }

        public void visit(SqlDistinct sqlDistinct) {
            this.visit1(sqlDistinct);
        }

        public void visit(SqlRestrict sqlRestrict) {
            this.visit1(sqlRestrict);
        }

        public void visit(SqlTable sqlTable) {
            this.visit0(sqlTable);
        }

        public void visit(SqlRename sqlRename) {
            this.visit1(sqlRename);
        }

        public void visit(SqlJoinInner sqlJoin) {
            this.visit2(sqlJoin);
        }

        public void visit(SqlJoinLeftOuter sqlJoin) {
            this.visit2(sqlJoin);
        }

        public void visit(SqlUnion sqlUnion) {
            this.visit2(sqlUnion);
        }

        public void visit(SqlCoalesce sqlCoalesce) {
            this.visit1(sqlCoalesce);
        }

        public void visit(SqlSlice sqlSlice) {
            this.visit1(sqlSlice);
        }

        public void visit(SqlSelectBlock sqlSelectBlock) {
            this.visit1(sqlSelectBlock);
        }
    }
}

