/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.core.Annotations;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlCoalesce;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlDistinct;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoin;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinInner;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlProject;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRename;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRestrict;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSlice;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlUnion;
import com.hp.hpl.jena.sdb.iterator.Stream;
import com.hp.hpl.jena.sdb.iterator.Transform;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sdb.shared.SDBNotImplemented;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSQLVisitor
implements SqlNodeVisitor {
    private static Log log = LogFactory.getLog(GenerateSQLVisitor.class);
    protected IndentedWriter out;
    int levelSelectBlock = 0;
    public boolean outputAnnotations = SDB.getContext().isTrueOrUndef(SDB.annotateGeneratedSQL);
    private static final int annotationColumn = 40;
    private static boolean commentSQLStyle = true;
    static final Transform<SqlColumn, SqlTable> colToTable = new Transform<SqlColumn, SqlTable>(){

        @Override
        public SqlTable convert(SqlColumn item) {
            return item.getTable();
        }
    };
    static boolean allOnOneLine = false;

    public GenerateSQLVisitor(IndentedWriter out) {
        this.out = out;
    }

    public void visit(SqlProject sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlDistinct sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlRestrict sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlSlice sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlRename sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    private void shouldNotSee(SqlNode sqlNode) {
        throw new SDBInternalError("Didn't expect: " + Utils.className((Object)sqlNode));
    }

    @Override
    public void visit(SqlSelectBlock sqlSelectBlock) {
        ++this.levelSelectBlock;
        if (this.levelSelectBlock > 1) {
            // empty if block
        }
        this.out.print((Object)"SELECT ");
        if (sqlSelectBlock.getDistinct()) {
            this.out.print((Object)"DISTINCT ");
        }
        if (this.annotate(sqlSelectBlock)) {
            this.out.ensureStartOfLine();
        }
        this.out.incIndent();
        this.print(sqlSelectBlock.getCols());
        this.out.decIndent();
        this.out.ensureStartOfLine();
        this.out.print((Object)"FROM");
        if (!sqlSelectBlock.getSubNode().isTable()) {
            this.out.println();
        } else {
            this.out.print((Object)" ");
        }
        this.out.incIndent();
        this.outputNode(sqlSelectBlock.getSubNode(), true);
        this.out.decIndent();
        this.out.ensureStartOfLine();
        if (sqlSelectBlock.getConditions().size() > 0) {
            this.genWHERE(sqlSelectBlock.getConditions());
        }
        this.out.ensureStartOfLine();
        this.genLimitOffset(sqlSelectBlock);
        --this.levelSelectBlock;
    }

    protected void genLimitOffset(SqlSelectBlock sqlSelectBlock) {
        if (sqlSelectBlock.getLength() >= 0L) {
            this.out.println((Object)("LIMIT " + sqlSelectBlock.getLength()));
        }
        if (sqlSelectBlock.getStart() >= 0L) {
            this.out.println((Object)("OFFSET " + sqlSelectBlock.getStart()));
        }
    }

    private void print(List<ColAlias> cols) {
        String sep = "";
        if (cols.size() == 0) {
            this.out.print((Object)"*");
        }
        String currentPrefix = null;
        String splitMarker = ".";
        for (ColAlias c : cols) {
            this.out.print((Object)sep);
            String cn = c.getColumn().getFullColumnName();
            int j = cn.lastIndexOf(splitMarker);
            if (j == -1) {
                currentPrefix = null;
            } else {
                String x = cn.substring(0, j);
                if (currentPrefix != null && !x.equals(currentPrefix)) {
                    this.out.println();
                }
                currentPrefix = x;
            }
            sep = ", ";
            this.out.print((Object)c.getColumn().getFullColumnName());
            if (c.getAlias() == null) continue;
            this.out.print((Object)this.aliasToken());
            this.out.print((Object)c.getAlias().getColumnName());
        }
    }

    private void genWHERE(SqlExprList conditions) {
        this.out.print((Object)"WHERE");
        this.out.print((Object)" ");
        this.out.incIndent();
        this.conditionList(conditions);
        this.out.decIndent();
    }

    @Override
    public void visit(SqlTable table) {
        this.out.print((Object)table.getTableName());
        this.out.print((Object)this.aliasToken());
        this.out.print((Object)table.getAliasName());
        this.annotate(table);
    }

    @Override
    public void visit(SqlJoinInner join) {
        join = this.rewrite(join);
        this.visitJoin(join);
    }

    public SqlJoinInner rewrite(SqlJoinInner join) {
        if (!join.getRight().isInnerJoin()) {
            return join;
        }
        SqlJoinInner right = join.getRight().asInnerJoin();
        String alias1 = join.getAliasName();
        String alias2 = right.getAliasName();
        SqlNode sn_a = join.getLeft();
        SqlNode sn_b = right.getLeft();
        SqlNode sn_c = right.getRight();
        SqlExprList conditions = new SqlExprList(join.getConditions());
        conditions.addAll(right.getConditions());
        Set<SqlTable> tables_ab = sn_a.tablesInvolved();
        tables_ab.addAll(sn_b.tablesInvolved());
        SqlExprList newCond_ab = new SqlExprList();
        SqlExprList newCond_c = new SqlExprList();
        for (SqlExpr e : conditions) {
            Set<SqlColumn> cols = e.getColumnsNeeded();
            Set<SqlTable> tables = GenerateSQLVisitor.tables(cols);
            tables.removeAll(tables_ab);
            if (tables.size() == 0) {
                newCond_ab.add(e);
                continue;
            }
            newCond_c.add(e);
        }
        if (newCond_ab.size() + newCond_c.size() != conditions.size()) {
            log.fatal((Object)String.format("Conditions mismatch: (%d,%d,%d)", newCond_ab.size(), newCond_c.size(), conditions.size()));
        }
        SqlJoinInner join2 = new SqlJoinInner(sn_a, sn_b);
        join2.addConditions(newCond_ab);
        join2 = new SqlJoinInner(join2, sn_c);
        join2.addConditions(newCond_c);
        return join2;
    }

    private static Set<SqlTable> tables(Set<SqlColumn> cols) {
        return Stream.toSet(Stream.map(cols, colToTable));
    }

    @Override
    public void visit(SqlJoinLeftOuter join) {
        this.visitJoin(join);
    }

    @Override
    public void visit(SqlCoalesce sqlNode) {
        this.out.print((Object)"SELECT ");
        boolean first = true;
        SqlJoin join = sqlNode.getJoinNode();
        for (Var v : sqlNode.getCoalesceVars()) {
            if (!first) {
                this.out.print((Object)", ");
            }
            SqlColumn col = sqlNode.getIdScope().findScopeForVar(v).getColumn();
            SqlColumn leftCol = join.getLeft().getIdScope().findScopeForVar(v).getColumn();
            SqlColumn rightCol = join.getRight().getIdScope().findScopeForVar(v).getColumn();
            this.out.print((Object)"COALESCE(");
            this.out.print((Object)leftCol.getFullColumnName());
            this.out.print((Object)", ");
            this.out.print((Object)rightCol.getFullColumnName());
            this.out.print((Object)")");
            this.out.print((Object)this.aliasToken());
            this.out.print((Object)col.getColumnName());
            first = false;
        }
        for (Var v : sqlNode.getNonCoalesceVars()) {
            if (!first) {
                this.out.print((Object)", ");
            }
            first = false;
            SqlColumn colSub = join.getIdScope().findScopeForVar(v).getColumn();
            SqlColumn col = sqlNode.getIdScope().findScopeForVar(v).getColumn();
            this.out.print((Object)colSub.getFullColumnName());
            this.out.print((Object)this.aliasToken());
            this.out.print((Object)col.getColumnName());
        }
        this.out.ensureStartOfLine();
        this.out.incIndent();
        this.out.println((Object)"FROM");
        join.visit(this);
        this.out.ensureStartOfLine();
    }

    @Override
    public void visit(SqlUnion sqlUnion) {
        throw new SDBNotImplemented("SQL generation of SqlUnion");
    }

    protected void visitJoin(SqlJoin join) {
        this.visitJoin(join, join.getJoinType().sqlOperator());
    }

    protected void visitJoin(SqlJoin join, String joinOperatorName) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        if (left.isJoin() && left.getAliasName() == null) {
            this.outputNode(left, false);
        } else {
            this.out.incIndent();
            this.outputNode(left, true);
            this.out.decIndent();
        }
        this.out.println();
        this.out.print((Object)joinOperatorName);
        this.annotate(join);
        this.out.println();
        boolean bracketsRight = true;
        if (bracketsRight) {
            this.out.incIndent();
        }
        this.outputNode(right, bracketsRight);
        if (bracketsRight) {
            this.out.decIndent();
        }
        this.out.println();
        this.out.print((Object)"ON ");
        if (join.getConditions().size() > 0) {
            this.conditionList(join.getConditions());
        } else {
            this.out.print((Object)" ( ");
            this.out.print((Object)this.leftJoinNoConditionsString());
            this.out.print((Object)" )");
        }
    }

    protected String aliasToken() {
        return " AS ";
    }

    protected String leftJoinNoConditionsString() {
        return "1 = 1";
    }

    public void conditionList(SqlExprList conditions) {
        if (conditions.size() == 0) {
            return;
        }
        this.out.print((Object)"( ");
        String sep = " AND ";
        boolean first = true;
        boolean lastAnnotated = false;
        for (SqlExpr c : conditions) {
            boolean needsParens;
            if (!first) {
                if (!allOnOneLine) {
                    this.out.println();
                }
                this.out.print((Object)sep);
            }
            boolean bl = needsParens = !(c instanceof S_Equal);
            if (needsParens) {
                this.out.print((Object)"( ");
            }
            this.out.print((Object)c.asSQL());
            if (needsParens) {
                this.out.print((Object)" )");
            }
            if (!allOnOneLine) {
                lastAnnotated = this.annotate(c);
            }
            first = false;
        }
        if (!allOnOneLine && lastAnnotated) {
            this.out.println((Object)"");
        }
        this.out.print((Object)" )");
        first = true;
        if (allOnOneLine) {
            for (SqlExpr c : conditions) {
                if (!c.hasNotes()) continue;
                if (!first) {
                    this.out.println();
                }
                this.annotate(c);
                first = false;
            }
        }
    }

    private void outputNode(SqlNode sqlNode, boolean mayNeedBrackets) {
        if (sqlNode.isTable()) {
            sqlNode.visit(this);
            return;
        }
        boolean brackets = false;
        brackets = brackets || mayNeedBrackets && sqlNode.isCoalesce();
        boolean bl = brackets = brackets || mayNeedBrackets && sqlNode.isSelectBlock();
        if (brackets) {
            this.out.print((Object)"( ");
            this.out.incIndent();
        }
        sqlNode.visit(this);
        if (brackets) {
            this.out.decIndent();
            this.out.ensureStartOfLine();
            this.out.print((Object)")");
        }
        if (sqlNode.getAliasName() != null) {
            this.out.print((Object)this.aliasToken());
            this.out.print((Object)sqlNode.getAliasName());
        }
        this.annotate(sqlNode);
    }

    private boolean annotate(Annotations sqlNode) {
        return this.annotate(sqlNode, 40);
    }

    private boolean annotate(Annotations sqlNode, int indentationColumn) {
        if (!this.outputAnnotations) {
            return false;
        }
        boolean first = true;
        for (String s : sqlNode.getNotes()) {
            if (!first) {
                this.out.println();
            }
            first = false;
            this.out.pad(indentationColumn, true);
            if (commentSQLStyle) {
                this.out.print((Object)" -- ");
                this.out.print((Object)s);
                continue;
            }
            this.out.print((Object)" /* ");
            this.out.print((Object)s);
            this.out.print((Object)" */");
        }
        return !commentSQLStyle || !first;
    }
}

